/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JFrame;
import weka.core.Instances;
import weka.gui.explorer.Explorer;
import weka.gui.visualize.MatrixPanel;

public class VisualizePanel
extends MatrixPanel
implements Explorer.ExplorerPanel {
    private static final long serialVersionUID = 6084015036853918846L;
    protected Explorer m_Explorer = null;

    public void setExplorer(Explorer explorer) {
        this.m_Explorer = explorer;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    public String getTabTitle() {
        return "Visualize";
    }

    public String getTabTitleToolTip() {
        return "Explore the data";
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Weka Explorer: Visualize");
            jFrame.getContentPane().setLayout(new BorderLayout());
            VisualizePanel visualizePanel = new VisualizePanel();
            jFrame.getContentPane().add((Component)visualizePanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
            if (stringArray.length == 1) {
                System.err.println("Loading instances from " + stringArray[0]);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
                Instances instances = new Instances(bufferedReader);
                visualizePanel.setInstances(instances);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

