/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;

public class Queue
implements Serializable {
    private static final long serialVersionUID = -1141282001146389780L;
    protected QueueNode m_Head = null;
    protected QueueNode m_Tail = null;
    protected int m_Size = 0;

    public final synchronized void removeAllElements() {
        this.m_Size = 0;
        this.m_Head = null;
        this.m_Tail = null;
    }

    public synchronized Object push(Object object) {
        QueueNode queueNode = new QueueNode(object);
        if (this.m_Head == null) {
            this.m_Head = this.m_Tail = queueNode;
        } else {
            this.m_Tail = this.m_Tail.next(queueNode);
        }
        ++this.m_Size;
        return object;
    }

    public synchronized Object pop() throws RuntimeException {
        if (this.m_Head == null) {
            throw new RuntimeException("Queue is empty");
        }
        Object object = this.m_Head.contents();
        --this.m_Size;
        this.m_Head = this.m_Head.next();
        if (this.m_Head == null) {
            this.m_Tail = null;
        }
        return object;
    }

    public synchronized Object peek() throws RuntimeException {
        if (this.m_Head == null) {
            throw new RuntimeException("Queue is empty");
        }
        return this.m_Head.contents();
    }

    public boolean empty() {
        return this.m_Head == null;
    }

    public int size() {
        return this.m_Size;
    }

    public String toString() {
        String string = "Queue Contents " + this.m_Size + " elements\n";
        QueueNode queueNode = this.m_Head;
        if (queueNode == null) {
            return string + "Empty\n";
        }
        while (queueNode != null) {
            string = string + queueNode.contents().toString() + "\n";
            queueNode = queueNode.next();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            Queue queue = new Queue();
            for (int i = 0; i < stringArray.length; ++i) {
                queue.push(stringArray[i]);
            }
            System.out.println("After pushing command line arguments");
            System.out.println(queue.toString());
            while (!queue.empty()) {
                System.out.println("Pop: " + queue.pop().toString());
            }
            try {
                queue.pop();
                System.out.println("ERROR: pop did not throw exception!");
            }
            catch (RuntimeException runtimeException) {
                System.out.println("Pop on empty queue correctly gave exception.");
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    protected class QueueNode
    implements Serializable {
        private static final long serialVersionUID = -5119358279412097455L;
        protected QueueNode m_Next;
        protected Object m_Contents;

        public QueueNode(Object object) {
            this.m_Contents = object;
            this.next(null);
        }

        public QueueNode next(QueueNode queueNode) {
            this.m_Next = queueNode;
            return this.m_Next;
        }

        public QueueNode next() {
            return this.m_Next;
        }

        public Object contents(Object object) {
            this.m_Contents = object;
            return this.m_Contents;
        }

        public Object contents() {
            return this.m_Contents;
        }
    }
}

