/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import weka.core.ClassDiscovery;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class OutputFormatDialog
extends JDialog {
    private static final long serialVersionUID = 2169792738187807378L;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected int m_Result = 1;
    protected static Vector m_OutputFormatClasses = null;
    protected static Vector m_OutputFormatNames = null;
    protected Class m_ResultMatrix = ResultMatrixPlainText.class;
    protected JComboBox m_OutputFormatComboBox = new JComboBox(m_OutputFormatNames);
    protected JSpinner m_MeanPrecSpinner = new JSpinner();
    protected JSpinner m_StdDevPrecSpinner = new JSpinner();
    protected JCheckBox m_ShowAverageCheckBox = new JCheckBox("");
    protected JCheckBox m_RemoveFilterNameCheckBox = new JCheckBox("");
    protected JButton m_OkButton = new JButton("OK");
    protected JButton m_CancelButton = new JButton("Cancel");
    protected int m_MeanPrec = 2;
    protected int m_StdDevPrec = 2;
    protected boolean m_RemoveFilterName = false;
    protected boolean m_ShowAverage = false;

    public OutputFormatDialog(Frame frame) {
        super(frame, "Output Format...", true);
        this.createDialog();
    }

    protected void createDialog() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(5, 2));
        this.getContentPane().add((Component)jPanel, "Center");
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.m_MeanPrecSpinner.getModel();
        spinnerNumberModel.setMaximum(new Integer(20));
        spinnerNumberModel.setMinimum(new Integer(0));
        spinnerNumberModel = (SpinnerNumberModel)this.m_StdDevPrecSpinner.getModel();
        spinnerNumberModel.setMaximum(new Integer(20));
        spinnerNumberModel.setMinimum(new Integer(0));
        JLabel jLabel = new JLabel("Mean Precision");
        jLabel.setDisplayedMnemonic('M');
        jLabel.setLabelFor(this.m_MeanPrecSpinner);
        jPanel.add(jLabel);
        jPanel.add(this.m_MeanPrecSpinner);
        jLabel = new JLabel("StdDev. Precision");
        jLabel.setDisplayedMnemonic('S');
        jLabel.setLabelFor(this.m_StdDevPrecSpinner);
        jPanel.add(jLabel);
        jPanel.add(this.m_StdDevPrecSpinner);
        jLabel = new JLabel("Output Format");
        jLabel.setDisplayedMnemonic('F');
        jLabel.setLabelFor(this.m_OutputFormatComboBox);
        jPanel.add(jLabel);
        jPanel.add(this.m_OutputFormatComboBox);
        this.m_OutputFormatComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputFormatDialog.this.getData();
            }
        });
        jLabel = new JLabel("Show Average");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setLabelFor(this.m_ShowAverageCheckBox);
        jPanel.add(jLabel);
        jPanel.add(this.m_ShowAverageCheckBox);
        jLabel = new JLabel("Remove filter classnames");
        jLabel.setDisplayedMnemonic('R');
        jLabel.setLabelFor(this.m_RemoveFilterNameCheckBox);
        jPanel.add(jLabel);
        jPanel.add(this.m_RemoveFilterNameCheckBox);
        jPanel = new JPanel(new FlowLayout(2));
        this.getContentPane().add((Component)jPanel, "South");
        this.m_CancelButton.setMnemonic('C');
        this.m_CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputFormatDialog.this.m_Result = 1;
                OutputFormatDialog.this.setVisible(false);
            }
        });
        this.m_OkButton.setMnemonic('O');
        this.m_OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputFormatDialog.this.getData();
                OutputFormatDialog.this.m_Result = 0;
                OutputFormatDialog.this.setVisible(false);
            }
        });
        jPanel.add(this.m_OkButton);
        jPanel.add(this.m_CancelButton);
        this.getRootPane().setDefaultButton(this.m_OkButton);
        this.pack();
    }

    private void setData() {
        this.m_MeanPrecSpinner.setValue(new Integer(this.m_MeanPrec));
        this.m_StdDevPrecSpinner.setValue(new Integer(this.m_StdDevPrec));
        this.m_ShowAverageCheckBox.setSelected(this.m_ShowAverage);
        this.m_RemoveFilterNameCheckBox.setSelected(this.m_RemoveFilterName);
        for (int i = 0; i < m_OutputFormatClasses.size(); ++i) {
            if (!m_OutputFormatClasses.get(i).equals(this.m_ResultMatrix)) continue;
            this.m_OutputFormatComboBox.setSelectedItem(m_OutputFormatNames.get(i));
            break;
        }
    }

    private void getData() {
        this.m_MeanPrec = Integer.parseInt(this.m_MeanPrecSpinner.getValue().toString());
        this.m_StdDevPrec = Integer.parseInt(this.m_StdDevPrecSpinner.getValue().toString());
        this.m_ShowAverage = this.m_ShowAverageCheckBox.isSelected();
        this.m_RemoveFilterName = this.m_RemoveFilterNameCheckBox.isSelected();
        this.m_ResultMatrix = (Class)m_OutputFormatClasses.get(this.m_OutputFormatComboBox.getSelectedIndex());
    }

    public void setMeanPrec(int n) {
        this.m_MeanPrec = n;
    }

    public int getMeanPrec() {
        return this.m_MeanPrec;
    }

    public void setStdDevPrec(int n) {
        this.m_StdDevPrec = n;
    }

    public int getStdDevPrec() {
        return this.m_StdDevPrec;
    }

    public void setResultMatrix(Class clazz) {
        this.m_ResultMatrix = clazz;
    }

    public Class getResultMatrix() {
        return this.m_ResultMatrix;
    }

    public void setRemoveFilterName(boolean bl) {
        this.m_RemoveFilterName = bl;
    }

    public boolean getRemoveFilterName() {
        return this.m_RemoveFilterName;
    }

    public void setShowAverage(boolean bl) {
        this.m_ShowAverage = bl;
    }

    public boolean getShowAverage() {
        return this.m_ShowAverage;
    }

    protected void setFormat() {
        for (int i = 0; i < m_OutputFormatClasses.size(); ++i) {
            if (!m_OutputFormatNames.get(i).toString().equals(this.m_OutputFormatComboBox.getItemAt(i).toString())) continue;
            this.m_OutputFormatComboBox.setSelectedIndex(i);
            break;
        }
    }

    public int getResult() {
        return this.m_Result;
    }

    public int showDialog() {
        this.m_Result = 1;
        this.setData();
        this.setVisible(true);
        return this.m_Result;
    }

    public static void main(String[] stringArray) {
        OutputFormatDialog outputFormatDialog = new OutputFormatDialog(null);
        if (outputFormatDialog.showDialog() == 0) {
            System.out.println("Accepted");
        } else {
            System.out.println("Aborted");
        }
    }

    static {
        Vector vector = ClassDiscovery.find(ResultMatrix.class.getName(), ResultMatrix.class.getPackage().getName());
        m_OutputFormatClasses = new Vector();
        m_OutputFormatNames = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            try {
                Class<?> clazz = Class.forName(vector.get(i).toString());
                ResultMatrix resultMatrix = (ResultMatrix)clazz.newInstance();
                m_OutputFormatClasses.add(clazz);
                m_OutputFormatNames.add(resultMatrix.getDisplayName());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

