/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import weka.associations.Item;
import weka.core.Attribute;

public class NominalItem
extends Item
implements Serializable {
    private static final long serialVersionUID = 2182122099990462066L;
    protected int m_valueIndex;

    public NominalItem(Attribute att, int valueIndex) throws Exception {
        super(att);
        if (att.isNumeric()) {
            throw new Exception("NominalItem must be constructed using a nominal attribute");
        }
        this.m_attribute = att;
        this.m_valueIndex = this.m_attribute.numValues() == 1 ? 0 : valueIndex;
    }

    public int getValueIndex() {
        return this.m_valueIndex;
    }

    public String getItemValueAsString() {
        return this.m_attribute.value(this.m_valueIndex);
    }

    public String getComparisonAsString() {
        return "=";
    }

    public String toString(boolean freq) {
        String result = this.m_attribute.name() + "=" + this.m_attribute.value(this.m_valueIndex);
        if (freq) {
            result = result + ":" + this.m_frequency;
        }
        return result;
    }

    public boolean equals(Object compareTo) {
        if (!(compareTo instanceof NominalItem)) {
            return false;
        }
        NominalItem b = (NominalItem)compareTo;
        return this.m_attribute.equals(b.getAttribute()) && this.m_valueIndex == b.getValueIndex();
    }
}

