/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Arrays;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.Matrix;

abstract class AbstractPackMatrix
extends AbstractMatrix {
    double[] data;
    int n;

    public AbstractPackMatrix(int n) {
        super(n, n);
        this.n = this.numRows;
        this.data = new double[(n * n + n) / 2];
    }

    public AbstractPackMatrix(Matrix A) {
        this(A, true);
    }

    public AbstractPackMatrix(Matrix A, boolean deep) {
        super(A);
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Packed matrix must be square");
        }
        this.n = A.numRows();
        if (deep) {
            this.data = new double[(this.n * this.n + this.n) / 2];
            this.copy(A);
        } else {
            this.data = ((AbstractPackMatrix)A).getData();
        }
    }

    abstract void copy(Matrix var1);

    public double[] getData() {
        return this.data;
    }

    @Override
    public Matrix set(Matrix B) {
        if (!(B instanceof AbstractPackMatrix)) {
            return super.set(B);
        }
        this.checkSize(B);
        double[] Bd = ((AbstractPackMatrix)B).getData();
        if (Bd == this.data) {
            return this;
        }
        System.arraycopy(Bd, 0, this.data, 0, this.data.length);
        return this;
    }

    @Override
    public Matrix zero() {
        Arrays.fill(this.data, 0.0);
        return this;
    }
}

