% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_table2pdf.R
\name{p_table2pdf}
\alias{p_table2pdf}
\alias{p_table}
\alias{p_table2}
\alias{p_table5}
\alias{p_table7}
\alias{table_pdf}
\alias{p_table3pdf}
\alias{p_table5pdf}
\alias{p_table7pdf}
\title{Package Information in Console and PDF Files}
\usage{
p_table(..., char = NULL, columns = c("Package", "Title", "Description"),
  crandb = get("crandb", envir = .GlobalEnv))

p_table2(..., char = NULL, crandb = get("crandb", envir = .GlobalEnv))

p_table5(..., char = NULL, crandb = get("crandb", envir = .GlobalEnv))

p_table7(..., char = NULL, crandb = get("crandb", envir = .GlobalEnv))

table_pdf(x, filename = "SelectedPkgs.tex", dir = ".",
  texops = "a4paper,landscape,10pt", pdf = TRUE, cleantex = TRUE,
  openpdf = TRUE, verbose = TRUE)

p_table2pdf(..., char = NULL, filename = "Selectedpkgs", dir = ".",
  texops = "a4paper,landscape,10pt", pdf = TRUE, cleantex = TRUE,
  openpdf = TRUE, verbose = TRUE, crandb = get("crandb", envir =
  .GlobalEnv))

p_table3pdf(..., char = NULL, filename = "Selectedpkgs", dir = ".",
  texops = "a4paper,landscape,10pt", pdf = TRUE, cleantex = TRUE,
  openpdf = TRUE, verbose = TRUE, crandb = get("crandb", envir =
  .GlobalEnv))

p_table5pdf(..., char = NULL, filename = "Selectedpkgs", dir = ".",
  texops = "a4paper,landscape,10pt", pdf = TRUE, cleantex = TRUE,
  openpdf = TRUE, verbose = TRUE, crandb = get("crandb", envir =
  .GlobalEnv))

p_table7pdf(..., char = NULL, filename = "Selectedpkgs", dir = ".",
  texops = "a4paper,landscape,10pt", pdf = TRUE, cleantex = TRUE,
  openpdf = TRUE, verbose = TRUE, crandb = get("crandb", envir =
  .GlobalEnv))
}
\arguments{
\item{...}{any format recognized by \code{\link{cnsc}}, including list.
A vector or a list of packages.}

\item{char}{(name to) a character vector. Use this argument if \code{...} fails 
or if you call the function from another function. If used, 
argument \code{...} is ignored.}

\item{columns}{character vector. A sub-vector of \code{colnames(crandb)}. The 
short form "P", "T", "D", "PT", "PD", "TD", "PTD", "A", "M", "AM" 
describing the Package name, Title, Description, Author, Maintainer
or a combination of them is accepted.}

\item{crandb}{data.frame \code{crandb}. The data.frame of CRAN packages.}

\item{x}{(list of) data.frame produced by \code{p_table} (with 3 columns), 
\code{p_table5} (5 columns) or \code{p_table7} (7 columns). If \code{x} 
is a list, the names of the list will be appended to \code{filename}.}

\item{filename}{character. The file name (with or without extension).}

\item{dir}{character. The directory in which the files are read or written. 
Default value \code{"."} is the current directory.}

\item{texops}{character vector. Options passed to instruction \code{documentclass} 
in *.tex file.}

\item{pdf}{logical. \code{FALSE} generates the *.tex file. 
\code{TRUE} generates both the *.tex and *.pdf files.}

\item{cleantex}{logical. Remove the \code{.tex} file(s) (only if \code{pdf = TRUE}).}

\item{openpdf}{logical. Open the generated *.pdf file(s) in a pdf viewer (only if
\code{pdf = TRUE}).}

\item{verbose}{logical. Print the path(s) to the generated file(s).}
}
\description{
\code{p_table} returns a subset of \code{crandb} for the given packages and the selected  
columns, by default the Package name, the Title and the Description. 

\code{p_table2} has a preset value to 2 columns: "Package", "Title" and prints the 
results in the console with a left alignment.

\code{p_table5} has a preset value to 5 columns: "Package", "Title", "Description", 
"Author", "Maintainer".

\code{p_table7} has a preset value to 7 columns: "Package", "Version", "Published", 
"Title", "Description", "Author", "Maintainer".

\code{table_pdf} prints the results of \code{p_table}, \code{p_table5} or \code{p_table7} 
in pdf file(s). Miktex or Texlive is required. 

\code{p_table2pdf}, \code{p_table3pdf}, \code{p_table5pdf}, \code{p_table7pdf} combine the 
above functions.
}
\examples{
## In real life, download crandb from CRAN or load it from your directory 
## with functions crandb_down() or crandb_load(). 
## In this example, we use a small file.
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))

## Use a large console (useful for p_table2())
p_table2(pacman, pdfsearch, sos)
(lst <- s_crandb_list("thermodynamic", "chemical reaction", "distillation"))
p_table2(lst)
dir <- file.path(tempdir(), "ppdf")
\donttest{
## print the tables as pdf files and open them in a pdf viewer.
p_table5pdf(pacman, pdfsearch, sos, dir = dir)
p_table7pdf(lst, dir = dir, cleantex = FALSE, openpdf = TRUE)
}

}
