% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Racmacs-package.R
\docType{package}
\name{Racmacs-package}
\alias{Racmacs}
\alias{Racmacs-package}
\title{Racmacs: Antigenic Cartography Macros}
\description{
\subsection{The acmap data object}{
The fundamental unit of the Racmacs package is the \link{acmap}
object, short for Antigenic Cartography MAP. This object contains all the
information about an antigenic map. You can read in a new acmap object from a
file with the function \link{read.acmap} and create a new acmap object within an
R session using the \link{acmap} function.

Key information associated with each acmap object is summarized in the
sections below.
}

\subsection{The titer table}{
Each \link{acmap} object is built upon a table of data of measurements the
reactivity of a set of different sera against a set of different antigens.
Typically these measurements are HI assay measurements, but it is also
possible to use other similar assays as input data.

For the table of data it is always assumed that sera form the \emph{columns} and
antigens form the \emph{rows}, as below. You can get and set titer data with
\link{titerTable}.
}

\subsection{Optimizations}{
Another key component of the \link{acmap} object is a list of optimizations.
While acmap objects only have one table of data, they can have many
optimizations or none at all.

Each optimization has the following main attributes (see the vignette on
optimizing antigenic maps for more details on minimum column bases and
stress):
\itemize{
\item \strong{Antigen coordinates}, the coordinates of each antigen in this
optimization.
\item \strong{Sera coordinates}, the coordinates of each serum in this optimization.
\item \strong{Minimum column basis}, the minimum column basis assumed when calculating
this optimization.
\item \strong{Stress}, the stress of this optimization.
\item \strong{Dimensions}, the number of dimensions of this optimization.
}
}

\subsection{Plotting styles}{
The final type of information that is contained in the acmap object is
information on point styles when plotting. By altering these attributes you
can change the appearance of the antigen and serum points in any maps
plotted, the main ones include:
\itemize{
\item Size
\item Shape
\item Fill color
\item Outline color
}

}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://acorg.github.io/Racmacs/}
  \item \url{https://github.com/acorg/Racmacs/}
  \item Report bugs at \url{https://github.com/acorg/Racmacs/issues}
}

}
\author{
\strong{Maintainer}: Sam Wilks \email{sw463@cam.ac.uk}

}
\keyword{internal}
