% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify.radviz.R
\name{identify.radviz}
\alias{identify.radviz}
\title{Identify a Point in a Radviz Projection}
\usage{
\method{identify}{radviz}(x, ..., n = 1)
}
\arguments{
\item{x}{a radviz object as produced by \code{\link{do.radviz}}}

\item{...}{further arguments to be passed to or from other methods}

\item{n}{the number of points to identify, defaults to 1}
}
\value{
an integer vector containing the indices of the identified points, 
in the order they were identified.
}
\description{
Use this function to get the index of a point in a Radviz projection
}
\details{
The function will use the row names of the \code{data} variable in the \code{rv} object 
for labeling the plot
}
\examples{
data(iris) 
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
plot(rv,point.shape=1,point.color=c('red','green','blue')[as.integer(iris$Species)])
identify(rv)

}
\author{
Yann Abraham
}
\seealso{
\code{\link[graphics]{identify}}
}

