% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_time.R
\name{gen_time}
\alias{gen_time}
\title{Calculate generation time from a matrix population model}
\usage{
gen_time(matU, matR)
}
\arguments{
\item{matU}{The survival component of a matrix population model (i.e., a
square projection matrix reflecting survival-related transitions; e.g.,
progression, stasis, and retrogression).}

\item{matR}{The reproductive component of a matrix population model (i.e., a
square projection matrix only reflecting transitions due to reproduction; either
sexual, clonal, or both).}
}
\value{
Returns generation time. If \code{matU} is singular (often indicating
  infinite life expectancy), returns \code{NA}.
}
\description{
Calculate generation time from a matrix population model. Generation time
is defined here as the time required for a population to increase by a factor
of R0 (the net reproductive rate). For more details refer to 
section 5.3.5 of Caswell (2001).
}
\details{
There are multiple definitions of generation time. Here we use \code{log(R0)
/ log(lambda)}, where \code{R0} is the net reproductive rate (the
per-generation population growth rate; Caswell 2001, Sec. 5.3.4), and
\code{lambda} is the population growth rate per unit time (the dominant
eigenvalue of \code{matU + matR}).
}
\note{
Note that the units of time in returned values are the same as the
  projection interval (`ProjectionInterval`) of the MPM.
}
\examples{
data(mpm1)

# calculate generation time
gen_time(matU = mpm1$matU, matR = mpm1$matF)

}
\references{
Caswell, H. 2001. Matrix Population Models: Construction,
  Analysis, and Interpretation. Sinauer Associates; 2nd edition. ISBN:
  978-0878930968
}
\seealso{
Other life history traits: 
\code{\link{entropy_d}()},
\code{\link{entropy_k}()},
\code{\link{life_expect_mean}()},
\code{\link{longevity}()},
\code{\link{net_repro_rate}()},
\code{\link{repro_maturity}},
\code{\link{shape_rep}()},
\code{\link{shape_surv}()}
}
\author{
Patrick Barks <patrick.barks@gmail.com>
}
\concept{life history traits}
