% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankDistance.R
\name{distKendall}
\alias{distKendall}
\title{Kendall distance between two ranks}
\usage{
distKendall(x, y, type = "ordering")
}
\arguments{
\item{x, y}{two ranks of size m.}

\item{type}{type of the rank representation ("ordering" ou "ranking").}
}
\value{
an integer, the Kendall distance between x and y.
}
\description{
The Kendall distance between two ranks is the number of pairs that are in different order in the two ranks.
}
\examples{
x <- 1:5
y <- c(2, 3, 1, 4, 5)
distKendall(x, y, type = "ordering")

}
\references{
A New Measure of Rank Correlation, M. G. Kendall
}
\seealso{
Other distance: 
\code{\link{distCayley}()},
\code{\link{distHamming}()},
\code{\link{distSpearman}()}
}
\author{
Julien Jacques
}
\concept{distance}
