% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompadreDB-Subsetting.R
\name{CompadreDB-Subsetting}
\alias{CompadreDB-Subsetting}
\alias{[,CompadreDB,ANY,ANY,ANY-method}
\alias{subset.CompadreDB}
\title{Subsetting CompadreDB objects}
\usage{
\S4method{[}{CompadreDB,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)

\method{subset}{CompadreDB}(x, subset, select, drop = FALSE, ...)
}
\arguments{
\item{x}{A \code{CompadreDB} object}

\item{i}{row indices (see \link{[.data.frame})}

\item{j}{column indices (see \link{[.data.frame})}

\item{...}{ignored}

\item{drop}{ignored}

\item{subset}{logical expression indicating which rows to keep}

\item{select}{expression indicating which columns to keep}
}
\value{
No return value, called for side effects
}
\description{
\code{CompadreDB} objects can be subset just like a regular
\code{data.frame}, using either \code{[} or \code{subset()}. Note, however,
that the \code{mat} column will always be retained during subsetting, even if
it is not included in the user's column subset.
}
\examples{
# subset to the first 10 rows
Compadre[1:10,]

# subset to the species 'Echinacea angustifolia'
subset(Compadre, SpeciesAccepted == "Echinacea angustifolia")

# remove the column SurvivalIssue
Compadre[,names(Compadre) != "SurvivalIssue"]

\dontrun{
# column selection doesn't include mat, but mat will still be returned with a
#  along with a warning
subset(Compadre, select = c("SpeciesAccepted", "Authors"))
}
}
