% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_KPCA.R
\name{do.kpca}
\alias{do.kpca}
\title{Kernel Principal Component Analysis}
\usage{
do.kpca(X, ndim = 2, preprocess = "null", kernel = c("gaussian", 1))
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is ``null'', and other methods of ``decorrelate'',``center'' , and ``whiten'' are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{kernel}{a vector containing name of a kernel and corresponding parameters. See also \code{\link{aux.kernelcov}} for complete description of Kernel Trick.}
}
\value{
a named list containing
\describe{
\item{Y}{an \code{(n-by-ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{vars}{variances of projected data / eigenvalues from kernelized covariance matrix.}
}
}
\description{
Kernel principal component analysis (KPCA/Kernel PCA) is a nonlinear extension of classical
PCA using techniques called \href{https://en.wikipedia.org/wiki/Kernel_method}{kernel trick},
a common method of introducing nonlinearity by transforming, usually, covariance structure or
other gram-type estimate to make it flexible in Reproducing Kernel Hilbert Space.
}
\examples{
## generate ribbon-shaped data
## in order to pass CRAN pretest, n is set to be small.
X = aux.gensamples(dname="ribbon",n=28)

## 1. standard KPCA with gaussian kernel
output1 <- do.kpca(X,ndim=2)

## 2. gaussian kernel with large bandwidth
output2 <- do.kpca(X,ndim=2,kernel=c("gaussian",5))

## 3. use laplacian kernel
output3 <- do.kpca(X,ndim=2,kernel=c("laplacian",1))

## Visualize three different projections
par(mfrow=c(1,3))
plot(output1$Y[,1],output1$Y[,2],main="Gaussian kernel")
plot(output2$Y[,1],output2$Y[,2],main="Gaussian kernel with sigma=5")
plot(output3$Y[,1],output3$Y[,2],main="Laplacian kernel")

}
\references{
Scholkopf, B., Smola, A., and Muller K-R. (1997) \emph{Kernel principal component analysis}.
International Conference on Artificial Neural Networks, Part 4:583-588.
}
\seealso{
\code{\link{aux.kernelcov}}
}
\author{
Kisung You
}
