% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_FA.R
\name{do.fa}
\alias{do.fa}
\title{Exploratory Factor Analysis}
\usage{
do.fa(X, ndim = 2, preprocess = "center", maxiter = 1000,
  tolerance = 1e-10)
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued number of loading variables, or target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is ``center'' and other methods of ``decorrelate'', or ``whiten''
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{maxiter}{maximum number of iterations for updating.}

\item{tolerance}{stopping criterion in a Frobenius norm.}
}
\value{
a named list containing
\describe{
\item{Y}{an \code{(n-by-ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p-by-ndim)} whose columns are basis for projection.}
\item{loadings}{an \code{(p-by-ndim)} matrix whose rows are extracted loading factors.}
\item{noise}{a length-\code{p} vector of estimated noise.}
}
}
\description{
\code{do.fa} is an optimization-based implementation of a popular technique,
\emph{Exploratory Factor Analysis}. \href{https://en.wikipedia.org/wiki/Factor_analysis#Exploratory_factor_analysis_versus_principal_components_analysis}{This link}
explains similarities and intrinsic differences between a closely-related method of Principal Component Analysis (PCA).
}
\examples{
## generate data
X = aux.gensamples()

## 1. use centered data
output1 <- do.fa(X,ndim=2)

## 2. use decorrelated data
output2 <- do.fa(X,ndim=2,preprocess="decorrelate")

## 3. use whitened data
output3 <- do.fa(X,ndim=2,preprocess="whiten")

## Visualize three different projections
par(mfrow=c(1,3))
plot(output1$Y[,1],output1$Y[,2],main="centered")
plot(output2$Y[,1],output2$Y[,2],main="decorrelated")
plot(output3$Y[,1],output3$Y[,2],main="whitened")



}
\author{
Kisung You
}
