% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LSDF.R
\name{do.lsdf}
\alias{do.lsdf}
\title{Locality Sensitive Discriminant Feature}
\usage{
do.lsdf(X, label, ndim = 2, type = c("proportion", 0.1),
  preprocess = c("null", "center", "whiten", "decorrelate"), gamma = 100)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null" and other options of "center", "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{gamma}{within-class weight parameter for same-class data.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Locality Sensitive Discriminant Feature (LSDF) is a semi-supervised feature selection method.
It utilizes both labeled and unlabeled data points in that labeled points are used to maximize
the margin between data opints from different classes, while labeled ones are used to discover
the geometrical structure of the data space.
}
\examples{
\dontrun{
## generate data of 3 types with clear difference
dt1  = aux.gensamples(n=33)-100
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+100

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## copy a label and let 20\% of elements be missing
nlabel = length(label)
nmissing = round(nlabel*0.20)
label_missing = label
label_missing[sample(1:nlabel, nmissing)]=NA

## try different neighborhood sizes
out1 = do.lsdf(X, label_missing, type=c("proportion",0.01))
out2 = do.lsdf(X, label_missing, type=c("proportion",0.1))
out3 = do.lsdf(X, label_missing, type=c("proportion",0.25))

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="1\% connectivity")
plot(out2$Y[,1], out2$Y[,2], main="10\% connectivity")
plot(out3$Y[,1], out3$Y[,2], main="25\% connectivity")
}

}
\references{
\insertRef{cai_locality_2007}{Rdimtools}
}
\author{
Kisung You
}
