% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_correlation.R
\name{est.correlation}
\alias{est.correlation}
\title{Correlation Dimension}
\usage{
est.correlation(X, nlevel = 50, show = FALSE)
}
\arguments{
\item{X}{an \code{(n-by-p)} matrix or data frame whose rows are observations.}

\item{nlevel}{the number of \code{r} (radius) to be tested.}

\item{show}{a logical; \code{FALSE} for not showing visually, \code{TRUE} otherwise.}
}
\value{
a named data frame containing \describe{
\item{r}{a vector of radius used.}
\item{Cr}{a vector of \eqn{C(r)} as decribed above.}
}
}
\description{
Correlation dimension is a measure of determining the dimension of a given set. It is
often referred to as a type of fractal dimension.  Its mechanism is somewhat similar to
that of box-counting dimension, but has the advantage of being intuitive as well as
efficient in terms of computation with some robustness contingent on the lack of availability for large dataset.
\deqn{dim(S) = \lim \frac{\log C(r)}{\log r}} as \eqn{r\rightarrow 0}, where
\eqn{C(r)=\lim (2/(N-1)*N)\sum_i^N \sum_{j=i+1}^N I(\|x_i-x_j\|\le r)}.
}
\section{Determining the dimension}{

In this version, no automated method is included due to lots of possibilities for adopting
any types of change point detection methods. Instead, we recommend using \emph{visual}
identification by looking at the slope of the linear part in the middle using either
\code{show=TRUE} flag or plotting as \code{plot(log(output$r),log(output$Cr))}.
}

\examples{
## generate three different dataset
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="twinpeaks")

## visually verify : all should have approximate slope of 2.
par(mfrow=c(1,3))
est.correlation(X1,show=TRUE)
est.correlation(X2,show=TRUE)
est.correlation(X3,show=TRUE)


}
\references{
Grassberger, P. and Procaccia, I. (1983) \emph{Measuring the strangeness of strange attractors}. Physica D9:189-208.
}
\seealso{
\code{\link{est.boxcount}}
}
\author{
Kisung You
}
