% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_KUDP.R
\name{do.kudp}
\alias{do.kudp}
\title{Kernel-Weighted Unsupervised Discriminant Projection}
\usage{
do.kudp(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  bandwidth = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{bandwidth}{bandwidth parameter for heat kernel as the equation above.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{interimdim}{the number of PCA target dimension used in preprocessing.}
}
}
\description{
Kernel-Weighted Unsupervised Discriminant Projection (KUDP) is a generalization of UDP where
proximity is given by weighted values via heat kernel,
\deqn{K_{i,j} = \exp(-\|x_i-x_j\|^2/bandwidth)}
whence UDP uses binary connectivity. If \code{bandwidth} is \eqn{+\infty}, it becomes
a standard UDP problem. Like UDP, it also performs PCA preprocessing for rank-deficient case.
}
\examples{
\donttest{
## generate sample data
X = aux.gensamples(n=200)

## use different kernel bandwidth
out1 <- do.kudp(X, bandwidth=0.1)
out2 <- do.kudp(X, bandwidth=10)
out3 <- do.kudp(X, bandwidth=1000)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="bandwidth=0.1")
plot(out2$Y, main="bandwidth=10")
plot(out3$Y, main="bandwidth=1000")
par(opar)
}

}
\references{
\insertRef{yang_globally_2007}{Rdimtools}
}
\seealso{
\code{\link{do.udp}}
}
\author{
Kisung You
}
\concept{linear_methods}
