% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_CGE.R
\name{do.cge}
\alias{do.cge}
\title{Constrained Graph Embedding}
\usage{
do.cge(
  X,
  label,
  ndim = 2,
  type = c("proportion", 0.1),
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations}

\item{label}{a length-\eqn{n} vector of data class labels. It should contain \code{NA} elements for missing label.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is \code{"null"}. See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Constrained Graph Embedding (CGE) is a semi-supervised embedding method that incorporates
partially available label information into the graph structure that find embeddings
consistent with the labels.
}
\examples{
## use iris data
data(iris)
X     = as.matrix(iris[,2:4])
label = as.integer(iris[,5])
lcols  = as.factor(label)

## copy a label and let 10\% of elements be missing
nlabel = length(label)
nmissing = round(nlabel*0.10)
label_missing = label
label_missing[sample(1:nlabel, nmissing)]=NA

## try different neighborhood sizes
out1 = do.cge(X, label_missing, type=c("proportion",0.01))
out2 = do.cge(X, label_missing, type=c("proportion",0.1))
out3 = do.cge(X, label_missing, type=c("proportion",0.25))

## visualize
opar = par(no.readonly=TRUE)
par(mfrow=c(3,1))
plot(out1$Y, main="1\% connected",  pch=19, col=lcols)
plot(out2$Y, main="10\% connected", pch=19, col=lcols)
plot(out3$Y, main="25\% connected", pch=19, col=lcols)
par(opar)

}
\references{
\insertRef{he_graph_2009}{Rdimtools}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
