% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_linear_BPCA.R
\name{do.bpca}
\alias{do.bpca}
\title{Bayesian Principal Component Analysis}
\usage{
do.bpca(X, ndim = 2, ...)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{...}{extra parameters including \describe{
\item{maxiter}{maximum number of iterations (default: 100).}
\item{reltol}{relative tolerance stopping criterion (default: 1e-4).}
}}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{mp.itercount}{the number of iterations taken for EM algorithm to converge.}
\item{mp.sigma2}{estimated \eqn{\sigma^2} value via EM algorithm.}
\item{mp.alpha}{length-\code{ndim-1} vector of relative weight for each base in \code{mp.W}.}
\item{mp.W}{an \eqn{(ndim\times ndim-1)} matrix from EM update.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Bayesian PCA (BPCA) is a further variant of PCA in that it imposes prior and encodes
basis selection mechanism. Even though the model is fully Bayesian, \code{do.bpca}
faithfully follows the original paper by Bishop in that it only returns the mode value
of posterior as an estimate, in conjunction with ARD-motivated prior as well as
consideration of variance to be estimated. Unlike PPCA, it uses full basis and returns
relative weight for each base in that the smaller \eqn{\alpha} value is, the more likely
corresponding column vector of \code{mp.W} to be selected as potential basis.
}
\examples{
\dontrun{
## use iris dataset
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
lab   = as.factor(iris[subid,5])

## compare BPCA with others
out1  <- do.bpca(X, ndim=2)
out2  <- do.pca(X,  ndim=2)
out3  <- do.lda(X, lab, ndim=2)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=lab, pch=19, cex=0.8, main="Bayesian PCA")
plot(out2$Y, col=lab, pch=19, cex=0.8, main="PCA")
plot(out3$Y, col=lab, pch=19, cex=0.8, main="LDA")
par(opar)
}

}
\references{
\insertRef{bishop_bayesian_1999}{Rdimtools}
}
\seealso{
\code{\link{do.pca}}, \code{\link{do.ppca}}
}
\author{
Kisung You
}
\concept{linear_methods}
