% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_clustering.R
\name{est.clustering}
\alias{est.clustering}
\title{Intrinsic Dimension Estimation via Clustering}
\usage{
est.clustering(X, kmin = round(sqrt(nrow(X))))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{kmin}{minimal number of neighborhood size to search over.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated intrinsic dimension.}
}
}
\description{
Instead of directly using neighborhood information, \code{est.clustering} adopts hierarchical
neighborhood information using \code{\link[stats]{hclust}} by recursively merging leafs
over the range of radii.
}
\examples{
\donttest{
## create 'swiss' roll dataset
X = aux.gensamples(dname="swiss")

## try different k values
out1 = est.clustering(X, kmin=5)
out2 = est.clustering(X, kmin=25)
out3 = est.clustering(X, kmin=50)

## print the results
line1 = paste0("* est.clustering : kmin=5  gives ",round(out1$estdim,2))
line2 = paste0("* est.clustering : kmin=25 gives ",round(out2$estdim,2))
line3 = paste0("* est.clustering : kmin=50 gives ",round(out3$estdim,2))
cat(paste0(line1,"\n",line2,"\n",line3))
}

}
\references{
\insertRef{eriksson_estimating_2012}{Rdimtools}
}
\author{
Kisung You
}
