% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_lm.test.R
\name{L_lm.test}
\alias{L_lm.test}
\title{Lagrange multiplier tests on record indicators}
\usage{
L_lm.test(
  XM_T,
  record = c("upper", "lower"),
  alternative = c("!=", "="),
  trend = c("positive", "negative"),
  B = 1000,
  rdist = stats::runif,
  parallel = FALSE,
  numCores = 2,
  seed = NULL
)
}
\arguments{
\item{XM_T}{A numeric vector, matrix (or data frame).}

\item{record}{A character string indicating the type of record, 
"upper" or "lower".}

\item{alternative}{A character indicating if the alternative hypothesis 
assume all series with the same distribution \code{"="} (asymptotic 
chi-squared) or different distribution \code{"!="} (Monte Carlo 
simulated p-value).}

\item{trend}{A character string indicating the type of alternative 
hypothesis, positive trend in location \code{"positive"} or
negative trend in location \code{"negative"}.}

\item{B}{An integer specifying the number of replicates used in the 
Monte Carlo approach. Only used if \code{alternative = '!='}.}

\item{rdist}{A function that simulates continuous random variables, 
e.g., \code{\link{runif}} (fastest in \code{stats} package), 
\code{\link{rnorm}} or \code{\link{rexp}}. Only used if 
\code{alternative = '!='}.}

\item{parallel}{If \code{TRUE}, then the Monte Carlo algorithm is done in 
parallel. This can give a significant speedup on multicore machines.
Only used if \code{alternative = '!='}.}

\item{numCores}{Allows the user to specify the amount of parallel processes
to be used if \code{parallel = TRUE} and \code{alternative = '!='}. 
If \code{NULL}, then the number of logical cores is automatically 
detected and all available cores are used.}

\item{seed}{A vector of the same length as the value of \code{samples}. 
Allows the user to specify the seed of each Monte Carlo simulation. 
If \code{NULL}, then no seed is specified. Only used if 
\code{alternative = '!='}.}
}
\value{
A list of class \code{"htest"}  with the following elements:
  \item{statistic}{Value of the  statistic.}
  \item{parameter}{Degrees of freedom of the approximate \eqn{\chi^2} 
    distribution, or number of replicates used in the Monte Carlo test.}
  \item{p.value}{P-value.}
  \item{method}{A character string indicating the type of test.}
  \item{data.name}{A character string giving the name of the data.}
  \item{alternative}{A character string indicating one of both alternative
    hypothesis.}
}
\description{
This function performs an asymptotic Lagrange multiplier test 
  or a Monte Carlo approach based on the record indicators \eqn{I_t} to 
  study the hypothesis of the classical record model.
}
\details{
The null hypothesis of this likelihood ratio tests is that in all
  the series, \eqn{m=1,\ldots,M}, the probability of record at time \eqn{t}
  is \eqn{1/t}, and the alternative depends on the \code{alternative} 
  argument. The probability at time \eqn{t} is any value, but equal in the 
  \eqn{M} series if \code{alternative = '='} or different in the 
  \eqn{M} series if \code{alternative = '!='}. The alternative hypothesis
  is more specific in the first case than in the second one.

  If \code{alternative = '='}, under the null, the likelihood ratio 
  statistic has an asymptotic \eqn{\chi^2} distribution with \eqn{T-1} 
  degrees of freedom. It has been seen that for the approximation to be 
  adequate \eqn{M} must be between 4 and 5 times greater than \eqn{T}. 
  
  If \code{alternative = '!='}, the asymptotic behaviour is not fulfilled, 
  but a Monte Carlo approach can be applied.
}
\examples{
L_lm.test(ZaragozaSeries, B = 200)

L_lm.test(series_rev(ZaragozaSeries), alternative = '=', trend = 'negative')
}
\seealso{
\code{\link{L_lr.test}}, \code{\link{L_global.test}}
}
\author{
Jorge Castillo-Mateo
}
