% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N_normal.test.R
\name{N_normal.test}
\alias{N_normal.test}
\title{Normal test on the number of records}
\usage{
N_normal.test(
  XM_T,
  weights = function(t) 1,
  record = c("upper", "lower"),
  distribution = c("normal", "t"),
  trend = c("positive", "negative")
)
}
\arguments{
\item{XM_T}{A numeric vector, matrix (or data frame).}

\item{weights}{A function indicating the weight given to the different 
records according to their position in the series,
e.g., if \code{function(t) t-1} then \eqn{\omega_t = t-1}.}

\item{record}{A character string indicating the type of record to be 
calculated, "upper" or "lower".}

\item{distribution}{A character string indicating the asymptotic 
distribution of the statistic, Normal distribution "normal" or 
Student's t-distribution "t".}

\item{trend}{A character string indicating the type of alternative 
hypothesis, positive trend in location \code{"positive"} or
negative trend in location \code{"negative"}.}
}
\value{
A \code{"htest"} object with elements:
  \item{statistic}{Value of the test statistic.}
  \item{parameter}{Only if \code{distribution = 't'}, degrees of freedom of 
    \eqn{t} statistic equal to \eqn{M-1}.}
  \item{p.value}{P-value.}
  \item{method}{A character string indicating the type of test performed.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
This function performs a test based on \eqn{N_T}, the number 
  of records in the observation period, to study the hypothesis of the 
  classical record model.
}
\details{
In this test the null hypothesis is that the expected value of 
  \eqn{N_T}, the number of records in the observation period 
  \eqn{t=1,\ldots,T} is \eqn{\mu_T =\sum_{i=1}^T 1/i} and the variance 
  \eqn{\sigma^2_T=\sum_{i=1}^T (1/i-1/i^2)}; these are the values obtained 
  under the classical record model (see  Arnold et al. (1998)).
  The test statistic is based on \eqn{\bar N_T}, the mean of the number of 
  records up to time t, calculated from a sample of \eqn{M} vectors 
  (columns in \code{XM_T}). The distribution of the statistic under the 
  null is asymptotically Normal.

  If the sequences of variables in the vectors are not i.i.d., but they have
  a monotonous positive trend, an unilateral alternative hypothesis must 
  be stated, which in the case of upper records is 
  \eqn{\mu_T >\sum_{i=1}^T 1/i} and 
  \eqn{\sigma^2_T>\sum_{i=1}^T (1/i-1/i^2)}, and in the case of lower 
  records is \eqn{\mu_T <\sum_{i=1}^T 1/i} and 
  \eqn{\sigma^2_T<\sum_{i=1}^T (1/i-1/i^2)}. The opposite happens if 
  the trend is negative.
  
  The statistic is calculated as
  \deqn{Z = \frac{\bar N_T - E(\bar N_T)}{\sqrt{Var(\bar N_T)}},}
  which follows a standard Normal distribution.
  
  If \code{distribution = "t"}, an estimation of the variance
  \eqn{\widehat{Var}(DM^\omega)} is computed from the sample, which is 
  why \eqn{M>1} is required in this case, and the statistic is 
  asymptotically t distributed.
}
\examples{
N_normal.test(ZaragozaSeries)
}
\references{
Arnold BC, Balakrishnan N, Nagaraja HN (1998). 
\emph{Records}. New York: Wiley.
}
\seealso{
\code{\link{N.plot}}
}
\author{
Jorge Castillo-Mateo
}
