% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate_PhenData.R
\name{simulate_PhenData}
\alias{simulate_PhenData}
\title{Simulation function for the RepeatABEL package.}
\usage{
simulate_PhenData(formula.FixedEffects = y ~ 1, genabel.data, n.obs,
  SNP.eff = NULL, SNP.nr = NULL, beta = NULL, VC = c(1, 1, 1),
  GRM = NULL, sim.gamma = FALSE)
}
\arguments{
\item{formula.FixedEffects}{A formula including the name of the simulated variable as response, and cofactors as fixed effects.}

\item{genabel.data}{A GenABEL object of class gwaa.data.}

\item{n.obs}{A vector including the number of observations per individual. The length of n.obs must be equal to the number if individuals in genabel.data.}

\item{SNP.eff}{The size of a simulated SNP.effect.}

\item{SNP.nr}{The SNP genotype that the SNP effect is simulated on. SNP.nr=i is the i:th SNP.}

\item{beta}{The simulated fixed effects. Must be equal to the number of cofactors simulated (including the intercept term).}

\item{VC}{A vector of length 3 including the simulated variances of the polygenic effect, permanent environmental effect and residuals, respectively.}

\item{GRM}{An optional input where the Genetic Relationship Matrix can be given. Otherwise it is computed using the GenABEL package.}

\item{sim.gamma}{A logical parameter specifying whether the residuals shuld be simulated from a gamma distribution or not. If specified as TRUE then residuals are drawn from a gamma distribution with variance equal to the residual variance specified in \code{VC[3]}}
}
\value{
Returns a data frame including the simulated phenotypic values, cofactors and IDs.
}
\description{
The function takes a GenABEL object as input and generates simulated phenotypic values for related individuals having repeated obserevations.
}
\examples{
data(gen.data)
 #Simulate 4 observations per individual
 set.seed(1234)
 Phen.Sim <- simulate_PhenData(y ~ age, genabel.data=gen.data,
                 n.obs=rep(4, nids(gen.data)), SNP.eff=1, SNP.nr=1000, VC=c(1,1,1))
 GWAS1 <- rGLS(y ~ age, genabel.data = gen.data, phenotype.data = Phen.Sim)
 plot(GWAS1, main="Simulated Data Results")
}
\author{
Lars Ronnegard
}

