% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTrep.R
\name{plotTrep}
\alias{plotTrep}
\title{A function to scatterplot 'Trep' column of a Trep dataframe
plotTrep function plots values in the 'Trep' column of the supplied dataframe as a function of
chromosome coordinates. The genome wide median is plotted as a pink line.}
\usage{
plotTrep(TrepDF, region = FALSE, plotting = TRUE)
}
\arguments{
\item{TrepDF}{A dataframe containing 'chrom','chromStart', 'chromEnd' and 'Trep' columns (dataframe).}

\item{region}{Only plot for the provided region in the format 'chrI:1000-3000' (string, optional).}

\item{plotting}{Should the plot object be sent to the default device? (boolean, defaults to TRUE).}
}
\description{
A function to scatterplot 'Trep' column of a Trep dataframe
plotTrep function plots values in the 'Trep' column of the supplied dataframe as a function of
chromosome coordinates. The genome wide median is plotted as a pink line.
}
\examples{
plotTrep(TrepDF,region="chrI")
}
\keyword{Trep}
\keyword{bioinformatics}
\keyword{genomics}
\keyword{scatterplot}
