/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.rdata;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTRegularTextRun;
import org.docx4j.dml.CTTableCellProperties;
import org.docx4j.dml.CTTextBody;
import org.docx4j.dml.CTTextBodyProperties;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.wml.Color;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.Text;
import org.lysis.rdata.RAtomicInterface;
import org.lysis.reporters.pptx4r.elements.Utils;
import org.lysis.reporters.pptx4r.tools.Format;
import org.lysis.reporters.tables.TableLayoutDOCX;
import org.lysis.reporters.tables.TableLayoutHTML;
import org.lysis.reporters.tables.TableLayoutPPTX;

public class RLogical
implements RAtomicInterface {
    Vector<String> data;

    public RLogical(Vector<String> data) {
        this.data = data;
    }

    @Override
    public void print() {
        int i = 0;
        while (i < this.size()) {
            System.out.println(this.data.get(i));
            ++i;
        }
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Object get(int i) {
        return this.data.get(i);
    }

    @Override
    public P getP(int i, TableLayoutDOCX tf) {
        P p = new P();
        R run = new R();
        Text text = new Text();
        PPr parProperties = tf.getLogicalPar();
        RPr textProperties = tf.getLogicalText();
        text.setValue(this.data.get(i));
        run.getContent().add(text);
        run.setRPr(textProperties);
        p.getContent().add(run);
        p.setPPr(parProperties);
        return p;
    }

    @Override
    public P getP(int i, TableLayoutDOCX tf, String fontColor) {
        P p = new P();
        R run = new R();
        Text text = new Text();
        PPr parProperties = tf.getLogicalPar();
        RPr textProperties = (RPr)XmlUtils.deepCopy((Object)tf.getLogicalText());
        Color col = new Color();
        col.setVal(fontColor);
        textProperties.setColor(col);
        text.setValue(this.data.get(i));
        run.getContent().add(text);
        run.setRPr(textProperties);
        p.getContent().add(run);
        p.setPPr(parProperties);
        return p;
    }

    @Override
    public TcPr getCellProperties(TableLayoutDOCX tf) {
        return tf.getLogicalCell();
    }

    @Override
    public CTTextBody getP(int i, TableLayoutPPTX tf) throws JAXBException {
        CTTextBody p = new CTTextBody();
        CTTextBodyProperties pp = new CTTextBodyProperties();
        CTTextListStyle ls = new CTTextListStyle();
        p.setBodyPr(pp);
        p.setLstStyle(ls);
        CTRegularTextRun textRun = Utils.getRun(this.data.get(i));
        textRun.setRPr(tf.getLogicalText());
        CTTextParagraph textPar = new CTTextParagraph();
        List runs = textPar.getEGTextRun();
        runs.add(textRun);
        textPar.setPPr(tf.getLogicalPar());
        p.getP().add(textPar);
        return p;
    }

    @Override
    public CTTextBody getP(int i, TableLayoutPPTX tf, String fontColor) throws Exception {
        CTTextBody p = new CTTextBody();
        CTTextBodyProperties pp = new CTTextBodyProperties();
        CTTextListStyle ls = new CTTextListStyle();
        p.setBodyPr(pp);
        p.setLstStyle(ls);
        CTRegularTextRun textRun = Utils.getRun(this.data.get(i));
        CTTextCharacterProperties chartext = (CTTextCharacterProperties)XmlUtils.deepCopy((Object)tf.getLogicalText());
        chartext.setSolidFill(Format.getCol(fontColor));
        textRun.setRPr(chartext);
        CTTextParagraph textPar = new CTTextParagraph();
        List runs = textPar.getEGTextRun();
        runs.add(textRun);
        textPar.setPPr(tf.getLogicalPar());
        p.getP().add(textPar);
        return p;
    }

    @Override
    public CTTableCellProperties getCellProperties(TableLayoutPPTX tf) {
        return tf.getLogicalCell();
    }

    @Override
    public LinkedHashMap<String, String> getCellProperties(TableLayoutHTML tf) {
        return tf.getLogicalCell();
    }

    @Override
    public String getTdCssClass() {
        return "LogicalCell";
    }

    @Override
    public String getHTML(int i, TableLayoutHTML tf) {
        String out = "";
        out = String.valueOf(out) + "<p class=\"LogicalPar\"><span class=\"LogicalText\">";
        out = String.valueOf(out) + this.data.get(i);
        out = String.valueOf(out) + "</span></p>";
        return out;
    }

    @Override
    public String getHTML(int i, String fontColor, TableLayoutHTML tf) {
        String out = "";
        out = String.valueOf(out) + "<p class=\"LogicalPar\"><span class=\"LogicalText\" style=\"color:" + fontColor + ";\">";
        out = String.valueOf(out) + this.data.get(i);
        out = String.valueOf(out) + "</span></p>";
        return out;
    }
}

