% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Section.R
\name{addSection.docx}
\alias{addSection.docx}
\title{Add a section into a docx object}
\usage{
\method{addSection}{docx}(doc, landscape = FALSE, ncol = 1,
  space_between = 0.3, columns.only = FALSE, ...)
}
\arguments{
\item{doc}{\code{\link{docx}} object where section has to be added}

\item{landscape}{logical value. Specify TRUE to get a section with horizontal page.}

\item{ncol}{\code{integer} number to specify how many columns the section should contains.}

\item{space_between}{width in inches of the space between columns of the section.}

\item{columns.only}{logical value, if set to TRUE, no break page will (continuous section).}

\item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{docx}}.
}
\description{
Add a section into a \code{\link{docx}} object.
It lets you change document orientation and split new
content along 2 or more columns.
The function requires you to add a section before and after
the item(s) that  you want to be on a landscape and/or
multicolumns mode page.
}
\examples{
\dontrun{
doc.filename = "addSection.docx"

# set default font size to 10
options( "ReporteRs-fontsize" = 10 )

doc = docx( )
doc = addSection(doc, landscape = TRUE, ncol = 2 ) 
doc = addPlot( doc = doc, fun = function() {
		barplot( 1:8, col = 1:8 )
	}, width = 3, height = 3, pointsize = 5)

doc = addColumnBreak(doc ) 
doc = addFlexTable(doc, FlexTable(head(iris) ) )

doc = addSection(doc, ncol = 2 ) 
doc = addParagraph( doc = doc, "Text 1.", "Normal" )
doc = addColumnBreak(doc ) 
doc = addParagraph( doc = doc, "Text 2.", "Normal" )


doc = addSection(doc, ncol = 2, columns.only = TRUE ) 
doc = addFlexTable(doc, FlexTable(head(iris) ) )
doc = addColumnBreak(doc ) 
doc = addParagraph( doc = doc, "Text 3.", "Normal" )


doc = addSection( doc ) 
doc = addFlexTable(doc, FlexTable(mtcars, add.rownames = TRUE) )
doc = addParagraph( doc = doc, "Text 4.", "Normal" )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{docx}}, \code{\link{addSection}}
}

