/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.pptx4r.elements.template;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.SlideMasterPart;
import org.lysis.reporters.pptx4r.elements.template.LayoutDescription;
import org.lysis.reporters.pptx4r.elements.template.ShapeDescription;
import org.lysis.reporters.tools.Debug;
import org.pptx4j.pml.Shape;
import org.pptx4j.pml.SldMaster;

public class MasterLayoutProperties {
    public static int TITLE = 0;
    public static int FOOTER = 1;
    public static int SLIDENUMBER = 2;
    public static int DATE = 3;
    public static int SUBTITLE = 4;
    public static int CRTTITLE = 5;
    public static int BODY = 6;
    private boolean hasBeenFed = false;
    HashMap<Integer, ShapeDescription> listShapeDescription = new HashMap();
    private HashMap<Integer, Boolean> listShapeExists = new HashMap();

    public boolean satisfied() {
        return this.hasBeenFed;
    }

    public MasterLayoutProperties() {
        this.listShapeExists.put(TITLE, false);
        this.listShapeExists.put(FOOTER, false);
        this.listShapeExists.put(SLIDENUMBER, false);
        this.listShapeExists.put(DATE, false);
        this.listShapeExists.put(SUBTITLE, false);
        this.listShapeExists.put(CRTTITLE, false);
        this.listShapeExists.put(BODY, false);
        this.hasBeenFed = false;
    }

    public ShapeDescription getShapeDescription(int what) {
        if (this.listShapeExists.containsKey(what)) {
            return this.listShapeDescription.get(what);
        }
        return null;
    }

    public void feed(PresentationMLPackage basedoc) throws InvalidFormatException {
        for (Map.Entry en : basedoc.getParts().getParts().entrySet()) {
            if (!((Part)en.getValue()).getContentType().equals("application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml")) continue;
            SlideMasterPart layoutPart = (SlideMasterPart)basedoc.getParts().getParts().get(new PartName(((PartName)en.getKey()).getName()));
            List slidesSet = ((SldMaster)layoutPart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
            for (Object element : slidesSet) {
                if (!element.getClass().equals(Shape.class)) continue;
                Shape s = (Shape)element;
                ShapeDescription sd = new ShapeDescription(s);
                if (Debug.doc_explorer) {
                    System.err.println("shape type: " + sd.getShapeType());
                }
                if (sd.getShapeType().equals("dt")) {
                    this.listShapeExists.put(LayoutDescription.DATE, true);
                    this.listShapeDescription.put(LayoutDescription.DATE, sd);
                    continue;
                }
                if (sd.getShapeType().equals("title")) {
                    this.listShapeExists.put(LayoutDescription.TITLE, true);
                    this.listShapeDescription.put(LayoutDescription.TITLE, sd);
                    continue;
                }
                if (sd.getShapeType().equals("ftr")) {
                    this.listShapeExists.put(LayoutDescription.FOOTER, true);
                    this.listShapeDescription.put(LayoutDescription.FOOTER, sd);
                    continue;
                }
                if (sd.getShapeType().equals("sldNum")) {
                    this.listShapeExists.put(LayoutDescription.SLIDENUMBER, true);
                    this.listShapeDescription.put(LayoutDescription.SLIDENUMBER, sd);
                    continue;
                }
                if (sd.getShapeType().equals("ctrTitle")) {
                    this.listShapeExists.put(LayoutDescription.CRTTITLE, true);
                    this.listShapeDescription.put(LayoutDescription.CRTTITLE, sd);
                    continue;
                }
                if (sd.getShapeType().equals("subTitle")) {
                    this.listShapeExists.put(LayoutDescription.SUBTITLE, true);
                    this.listShapeDescription.put(LayoutDescription.SUBTITLE, sd);
                    continue;
                }
                if (!sd.getShapeType().equals("body")) continue;
                this.listShapeExists.put(LayoutDescription.BODY, true);
                this.listShapeDescription.put(LayoutDescription.BODY, sd);
            }
        }
        this.hasBeenFed = true;
    }
}

