% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCodeBlock.R
\name{addCodeBlock}
\alias{addCodeBlock}
\alias{addCodeBlock.bsdoc}
\alias{addCodeBlock.docx}
\alias{addCodeBlock.pptx}
\title{Add code block into a document object}
\usage{
addCodeBlock(doc, file, text, ...)

\method{addCodeBlock}{docx}(doc, file, text, par.properties = parProperties(),
  text.properties = textProperties(color = "#A7947D"), bookmark, ...)

\method{addCodeBlock}{bsdoc}(doc, file, text,
  par.properties = parProperties(), text.properties = textProperties(color =
  "#A7947D"), ...)

\method{addCodeBlock}{pptx}(doc, file, text, par.properties = parProperties(),
  text.properties = textProperties(color = "#A7947D"), append = FALSE, ...)
}
\arguments{
\item{doc}{document object}

\item{file}{script file. Not used if text is provided.}

\item{text}{character vector. The text to parse.
Not used if file is provided.}

\item{...}{further arguments passed to other methods}

\item{par.properties}{code block paragraph properties.
An object of class \code{\link{parProperties}}}

\item{text.properties}{code block text properties.
An object of class \code{\link{textProperties}}}

\item{bookmark}{Only for \code{docx}. A character value ; id of the Word bookmark to
replace by the script. optional. See \code{\link{bookmark}}.}

\item{append}{Only for \code{pptx}. boolean default to FALSE. If TRUE, paragraphs will be
appened in the current shape instead of beeing sent into a new shape.
Paragraphs can only be appended on shape containing paragraphs (i.e. you
can not add paragraphs after a FlexTable).}
}
\value{
a document object
}
\description{
Add a code block into a document object
}
\examples{

# docx example ---------
doc.filename = "ex_codeblock.docx"

options( "ReporteRs-fontsize" = 10 )
doc <- docx( )
doc <- addCodeBlock( doc, text = "ls -a\\nwhich -a ls" )

writeDoc( doc, file = doc.filename )

# bsdoc example --------
doc.filename = "ex_codeblock/example.html"

options( "ReporteRs-fontsize" = 11 )
doc = bsdoc( )
doc <- addCodeBlock( doc, text = "ls -a\\nwhich -a ls" )

writeDoc( doc, file = doc.filename )

# docx example ---------
doc.filename = "ex_codeblock.pptx"

options( "ReporteRs-fontsize" = 24 )
doc = pptx( title = "title" )

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addTitle( doc, "Title example 1" )
doc <- addCodeBlock( doc, text = "ls -a\\nwhich -a ls" )

writeDoc( doc, file = doc.filename )
}
\seealso{
\code{\link{bsdoc}}, \code{\link{docx}}, \code{\link{pptx}}
}

