/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.html4r.elements;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.tools.HTML4R;

public class SVGContent
implements HTML4R {
    private String svg_str;
    private ParProperties parProperties;
    private String id;
    private String tooltip_extra_css;
    private String hover_css;
    private boolean ggiraph;

    public SVGContent(ParProperties pp, String file, String id, String tooltip_extra_css, String hover_css, boolean ggiraph) throws IOException {
        String s;
        this.parProperties = pp;
        this.svg_str = "";
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((s = in.readLine()) != null) {
            this.svg_str = String.valueOf(this.svg_str) + s;
        }
        in.close();
        this.id = id;
        this.tooltip_extra_css = tooltip_extra_css;
        this.hover_css = hover_css;
        this.ggiraph = ggiraph;
    }

    @Override
    public String getHTML() {
        LinkedHashMap<String, String> ppr = this.parProperties.get_html_pp();
        String pStart = "<div style=\"" + Format.getJSString(ppr) + "\">";
        String pStop = "</div>";
        return String.valueOf(pStart) + this.svg_str + pStop;
    }

    @Override
    public String getCSS() {
        if (!this.ggiraph) {
            return "";
        }
        String tooltip_class = "tooltip" + this.id;
        String tooltip_css = "div." + tooltip_class + " {position:absolute;pointer-events:none;";
        tooltip_css = String.valueOf(tooltip_css) + this.tooltip_extra_css + "}";
        tooltip_css = String.valueOf(tooltip_css) + ".cl" + this.id + ":{}.cl" + this.id + ":hover{" + this.hover_css + "}";
        return tooltip_css;
    }

    @Override
    public String getJS() {
        if (!this.ggiraph) {
            return "";
        }
        String tooltip_class = "tooltip" + this.id;
        String js = "";
        js = String.valueOf(js) + "var div = d3.select(\"body\").append(\"div\").attr(\"class\", \"" + tooltip_class + "\").style(\"opacity\", 0);";
        js = String.valueOf(js) + "function d3_set_attr" + this.id + "(selection, name, value) {selection.attr(name, value);};";
        js = String.valueOf(js) + "var sel_data_id = d3.selectAll('#svg_" + this.id + " *[data-id]');";
        js = String.valueOf(js) + "sel_data_id.call(d3_set_attr" + this.id + ", \"class\", \"cl" + this.id + "\");";
        js = String.valueOf(js) + "var sel_tooltiped = d3.selectAll('#svg_" + this.id + " *[title]');";
        js = String.valueOf(js) + "sel_tooltiped.on(\"mouseover\", function(d) {";
        js = String.valueOf(js) + "div.transition().duration(200).style(\"opacity\", .90);";
        js = String.valueOf(js) + "div.html(d3.select(this).attr(\"title\"))";
        js = String.valueOf(js) + ".style(\"left\", (d3.event.pageX + 10 ) + \"px\")";
        js = String.valueOf(js) + ".style(\"top\", (d3.event.pageY  ) + \"px\");";
        js = String.valueOf(js) + "})";
        js = String.valueOf(js) + ".on(\"mouseout\", function(d) {";
        js = String.valueOf(js) + "div.transition().duration(500).style(\"opacity\", 0);});";
        js = String.valueOf(js) + "function zoom_h" + this.id + "() {d3.select(this).attr(\"transform\", \"translate(\" + d3.event.translate + \")scale(\" + d3.event.scale + \")\");}";
        js = String.valueOf(js) + "var zoom_l" + this.id + " = d3.behavior.zoom().scaleExtent([1, 8]).on(\"zoom\", zoom_h" + this.id + ");";
        js = String.valueOf(js) + "zoom_l" + this.id + "(d3.select('#svg_" + this.id + " g'));";
        return js;
    }

    @Override
    public boolean hasJS() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return true;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }
}

