% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addParagraph.R
\name{addParagraph}
\alias{addParagraph}
\alias{addParagraph.docx}
\alias{addParagraph.bsdoc}
\alias{addParagraph.pptx}
\title{Add a paragraph into a document object}
\usage{
addParagraph(doc, value, ...)

\method{addParagraph}{docx}(doc, value, stylename, bookmark,
  par.properties = parProperties(), restart.numbering = FALSE, ...)

\method{addParagraph}{bsdoc}(doc, value, par.properties = parProperties(),
  restart.numbering = FALSE, ...)

\method{addParagraph}{pptx}(doc, value, offx, offy, width, height,
  par.properties, append = FALSE, restart.numbering = FALSE, ...)
}
\arguments{
\item{doc}{document object}

\item{value}{text to add to the document as paragraphs:
an object of class \code{\link{pot}} or \code{\link{set_of_paragraphs}}
or a character vector.}

\item{...}{further arguments passed to other methods}

\item{stylename}{value of the named style to apply to paragraphs in the docx document.
Expected value is an existing stylename of the template document used to create the
\code{docx} object. see \code{\link{styles.docx}}.}

\item{bookmark}{a character value ; id of the Word bookmark to
replace by the table. optional. See \code{\link{bookmark}}.}

\item{par.properties}{\code{\link{parProperties}} to apply to paragraphs, only used
if \code{stylename} if missing.}

\item{restart.numbering}{boolean value. If \code{TRUE}, next numbered
list counter will be set to 1.}

\item{offx}{optional, x position of the shape (top left position of the bounding box)
in inches. See details.}

\item{offy}{optional, y position of the shape (top left position of the bounding box)
in inches. See details.}

\item{width}{optional, width of the shape in inches. See details.}

\item{height}{optional, height of the shape in inches. See details.}

\item{append}{boolean default to FALSE. If TRUE, paragraphs will be
appened in the current shape instead of beeing sent into a new shape.
Paragraphs can only be appended on shape containing paragraphs (i.e. you
can not add paragraphs after a FlexTable). Applies to only \code{pptx} objects.}
}
\value{
a document object
}
\description{
Add a paragraph into a document object
}
\details{
a paragraph is a set of text that ends with an end of line.
Read \code{\link{pot}} to see how to get different font formats.
If an end of line is required, a new paragraph is required.

When document is a \code{pptx} object, two positioning methods are available.

If arguments offx, offy, width, height are missing, position and dimensions
will be defined by the width and height of the next available shape of the slide. This
dimensions can be defined in the layout of the PowerPoint template used to create
the \code{pptx} object.

If arguments offx, offy, width, height are provided, they become position and
dimensions of the new shape.

Also, when document is a \code{pptx} object,
shading and border settings of argument \code{par.properties}
will have no effect.
}
\examples{

# docx example ---------
doc.filename = "ex_paragraph.docx"
doc <- docx()
styles(doc)

doc = addTitle( doc, "Title example 1", level = 1 )

# Add "Hello World" into the document doc
doc = addParagraph(doc, "Hello Word", stylename = "Normal" )

doc = addTitle( doc, "Title example 2", level = 1 )

# define some text
sometext = c( "Lorem ipsum dolor sit amet, consectetur adipiscing elit.", 
"In sit amet ipsum tellus. Vivamus dignissim arcu sit amet faucibus auctor.", 
"Quisque dictum tristique ligula.")

# add sometext with stylename BulletList
doc = addParagraph( doc, value = sometext, stylename="BulletList" )

doc = addTitle( doc, "Title example 3", level = 1 )

# "My tailor is rich" with formatting on some words
pot1 = pot("My tailor", textProperties(color = "red" ) 
  ) + " is " + pot("rich", textProperties(shading.color = "red", 
  font.weight = "bold" ) )

# "Cats and dogs" with formatting on some words
pot2 = pot("Cats", textProperties(color = "red" ) ) + 
  " and " + 
  pot("dogs", textProperties( color = "blue" ), 
    hyperlink = "http://www.wikipedia.org/" )

# create a set of paragraphs made of pot1 and pot2
my.pars = set_of_paragraphs( pot1, pot2 )

# Add my.pars into the document doc
doc = addParagraph(doc, my.pars, stylename = "Normal" )

doc = addTitle( doc, "Title example 4", level = 1 )
# define some text
text1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit."
text2 = "In sit amet ipsum tellus. Vivamus arcu sit amet faucibus auctor."
text3 = "Quisque dictum tristique ligula."

# define parProperties with list properties
ordered.list.level1 = parProperties(list.style = "ordered", 
	level = 1 )
ordered.list.level2 = parProperties(list.style = "ordered", 
	level = 2 )

# define parProperties with list properties
unordered.list.level1 = parProperties(list.style = "unordered", 
	level = 1 )
unordered.list.level2 = parProperties(list.style = "unordered", 
	level = 2 )

# add ordered list items 
doc = addParagraph( doc, value = text1, 
	par.properties = ordered.list.level1 )
doc = addParagraph( doc, value = text2, 
	par.properties = ordered.list.level2 )

# add ordered list items without restart renumbering
doc = addParagraph( doc, value = c( text1, text2, text3), 
	par.properties = ordered.list.level1 )

# add ordered list items and restart renumbering
doc = addParagraph( doc, value = c( text1, text2, text3), 
restart.numbering = TRUE, par.properties = ordered.list.level1 )

# add unordered list items
doc = addParagraph( doc, value = text1, 
	par.properties = unordered.list.level1 )
doc = addParagraph( doc, value = text2, 
	par.properties = unordered.list.level2 )


writeDoc( doc, file = doc.filename )

# pptx example -------
doc.filename = "ex_paragraph.pptx"

options( "ReporteRs-fontsize" = 24 )
doc = pptx( title = "title" )

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addTitle( doc, "Title example 1" )

# Add "Hello World" into the document doc
doc = addParagraph(doc, "Hello Word" )

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addTitle( doc, "Title example 2" )

# "My tailor is rich" with formatting on some words
pot1 = pot("My tailor", textProperties(color = "red" ) 
  ) + " is " + pot("rich", textProperties(shading.color = "red", 
  font.weight = "bold" ) )

# "Cats and dogs" with formatting on some words
pot2 = pot("Cats", textProperties(color = "red" ) ) + 
  " and " + 
  pot("dogs", textProperties( color = "blue" ), 
    hyperlink = "http://www.wikipedia.org/" )

# create a set of paragraphs made of pot1 and pot2
my.pars = set_of_paragraphs( pot1, pot2 )

# Add my.pars into the document doc
doc = addParagraph(doc, my.pars )

# Add my.pars into the document doc
doc = addParagraph(doc, my.pars, offx = 3, offy = 3, 
  width = 2, height = 0.5,
  par.properties=parProperties(text.align="center", padding=0) )

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addTitle( doc, "Title example 3" )

# "My tailor is rich" with formatting on some words
pot1 = pot("My tailor", textProperties(color = "red" ) 
  ) + " is " + pot("rich", textProperties(shading.color = "red", 
  font.weight = "bold" ) )

# "Cats and dogs" with formatting on some words
pot2 = pot("Cats", textProperties(color = "red" ) ) + 
  " and " + 
  pot("dogs", textProperties( color = "blue" ), 
    hyperlink = "http://www.wikipedia.org/" )

# create a set of paragraphs made of pot1 and pot2
my.pars = set_of_paragraphs( pot1, pot2 )

# Add my.pars into the document doc
doc = addParagraph(doc, my.pars, 
  par.properties=parProperties(text.align="center", padding=24) )

# add a slide with layout "Title and Content"
doc = addSlide( doc, slide.layout = "Title and Content" )

doc = addTitle( doc, "Title example 1" )
# define some text
text1 = "Lorem ipsum dolor sit amet, consectetur adipiscing elit."
text2 = "In sit amet ipsum tellus. Vivamus arcu sit faucibus auctor."
text3 = "Quisque dictum tristique ligula."

# define parProperties with list properties
ordered.list.level1 = parProperties(list.style = "ordered", 
	level = 1 )
ordered.list.level2 = parProperties(list.style = "ordered", 
	level = 2 )

# define parProperties with list properties
unordered.list.level1 = parProperties(list.style = "unordered", 
	level = 1 )
unordered.list.level2 = parProperties(list.style = "unordered", 
	level = 2 )

# add ordered list items 
doc = addParagraph( doc, value = text1, 
	par.properties = ordered.list.level1 )
doc = addParagraph( doc, value = text2, append = TRUE, 
	par.properties = ordered.list.level2 )

doc = addParagraph(doc, "This paragraph has no list attribute", 
	append = TRUE )

# add ordered list items without restart renumbering
doc = addParagraph( doc, value = c( text1, text2, text3), 
	append = TRUE, par.properties = ordered.list.level1 )

# add ordered list items and restart renumbering
doc = addParagraph( doc, value = c( text1, text2, text3), 
	append = TRUE, restart.numbering = TRUE, 
	par.properties = ordered.list.level1 )

# add unordered list items
doc = addParagraph( doc, value = text1, 
		append = TRUE, 
		par.properties = unordered.list.level1 )
doc = addParagraph( doc, value = text2, 
		append = TRUE, 
		par.properties = unordered.list.level2 )


writeDoc( doc, file = doc.filename )
}
\seealso{
\code{\link{docx}}, \code{\link{pptx}}, \code{\link{bsdoc}},
\code{\link{pot}}, \code{\link{textProperties}}, \code{\link{parProperties}}
}

