% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlexTablePublicAPI.R
\name{setColumnsColors}
\alias{setColumnsColors}
\title{applies background colors to columns of a FlexTable}
\usage{
setColumnsColors(object, j, colors)
}
\arguments{
\item{object}{a \code{FlexTable} object}

\item{j}{vector (integer index, col.names values or boolean vector) for columns selection.}

\item{colors}{background colors to apply (e.g. "#000000" or "black")}
}
\description{
applies background colors to columns of a FlexTable
}
\examples{
#
# Create a FlexTable object with first 10 lines of data.frame mtcars
# add row.names as first column
MyFTable = FlexTable( data = mtcars[1:10, ]
  , add.rownames=TRUE
)
MyFTable = setColumnsColors( MyFTable, j=3:4, colors = "red" )
}
\seealso{
\code{\link{setRowsColors}}, \code{\link{FlexTable}}, \code{\link{setZebraStyle}}
}

