/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.DocDefaults;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StyleDefinitionsPart
extends JaxbXmlPartXPathAware<Styles> {
    private static Logger log = LoggerFactory.getLogger(StyleDefinitionsPart.class);
    private static Map<String, Style> knownStyles = null;
    private Style styleDocDefaults;
    private Style defaultCharacterStyle;
    private static final String DEFAULT_CHARACTER_STYLE_DEFAULT = "<w:style w:type=\"character\" w:default=\"1\" w:styleId=\"DefaultParagraphFont\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:name w:val=\"Default Paragraph Font\" /></w:style>";
    private Style defaultParagraphStyle;
    private Style defaultTableStyle;
    static final String wNamespaceDec = " xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"";
    public static final String rPrDefaultsString = "<w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr>";
    public static final String pPrDefaultsString = "<w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr>";
    public static final String docDefaultsString = "<w:docDefaults xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:rPrDefault><w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr></w:rPrDefault><w:pPrDefault><w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr></w:pPrDefault></w:docDefaults>";
    private String css;

    public StyleDefinitionsPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public StyleDefinitionsPart() throws InvalidFormatException {
        super(new PartName("/word/styles.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles");
    }

    @Override
    public void setJaxbElement(Styles jaxbElement) {
        super.setJaxbElement(jaxbElement);
        this.styleDocDefaults = null;
        this.defaultCharacterStyle = null;
        this.defaultParagraphStyle = null;
        this.defaultTableStyle = null;
        this.css = null;
    }

    public Object unmarshalDefaultStyles() throws JAXBException {
        InputStream is = null;
        try {
            is = ResourceUtils.getResource("org/docx4j/openpackaging/parts/WordprocessingML/styles.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.unmarshal(is);
    }

    private static void initKnownStyles() {
        InputStream is = null;
        try {
            is = ResourceUtils.getResource("org/docx4j/openpackaging/parts/WordprocessingML/KnownStyles.xml");
            JAXBContext jc = Context.jc;
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            Styles styles = (Styles)u.unmarshal(is);
            knownStyles = new HashMap<String, Style>();
            for (Style s : styles.getStyle()) {
                knownStyles.put(s.getStyleId(), s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Style> getKnownStyles() {
        if (knownStyles == null) {
            StyleDefinitionsPart.initKnownStyles();
        }
        return knownStyles;
    }

    public void createVirtualStylesForDocDefaults() throws Docx4JException {
        RPr documentDefaultRPr;
        PPr documentDefaultPPr;
        if (this.styleDocDefaults != null) {
            return;
        }
        this.styleDocDefaults = Context.getWmlObjectFactory().createStyle();
        String ROOT_NAME = "DocDefaults";
        this.styleDocDefaults.setStyleId(ROOT_NAME);
        this.styleDocDefaults.setType("paragraph");
        Style.Name n = Context.getWmlObjectFactory().createStyleName();
        n.setVal(ROOT_NAME);
        this.styleDocDefaults.setName(n);
        DocDefaults docDefaults = ((Styles)this.getJaxbElement()).getDocDefaults();
        if (docDefaults == null) {
            log.warn("No DocDefaults present");
            try {
                docDefaults = (DocDefaults)XmlUtils.unmarshalString(docDefaultsString);
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:docDefaults xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:rPrDefault><w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr></w:rPrDefault><w:pPrDefault><w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr></w:pPrDefault></w:docDefaults>", (Exception)((Object)e));
            }
        }
        if (docDefaults.getPPrDefault() == null) {
            log.warn("No PPrDefault present");
            try {
                documentDefaultPPr = (PPr)XmlUtils.unmarshalString(pPrDefaultsString);
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr>", (Exception)((Object)e));
            }
        } else {
            documentDefaultPPr = docDefaults.getPPrDefault().getPPr();
            if (documentDefaultPPr == null) {
                documentDefaultPPr = Context.getWmlObjectFactory().createPPr();
            }
        }
        if (documentDefaultPPr.getSpacing() == null) {
            PPrBase.Spacing spacing = Context.getWmlObjectFactory().createPPrBaseSpacing();
            documentDefaultPPr.setSpacing(spacing);
            spacing.setBefore(BigInteger.ZERO);
            spacing.setAfter(BigInteger.ZERO);
            spacing.setLine(BigInteger.valueOf(240L));
        }
        if (docDefaults.getRPrDefault() == null) {
            log.warn("No RPrDefault present");
            try {
                documentDefaultRPr = (RPr)XmlUtils.unmarshalString(rPrDefaultsString);
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr>", (Exception)((Object)e));
            }
        } else {
            documentDefaultRPr = docDefaults.getRPrDefault().getRPr();
            if (documentDefaultRPr == null) {
                documentDefaultRPr = Context.getWmlObjectFactory().createRPr();
            }
        }
        this.styleDocDefaults.setPPr(documentDefaultPPr);
        this.styleDocDefaults.setRPr(documentDefaultRPr);
        Style normal = this.getDefaultParagraphStyle();
        if (normal == null) {
            log.warn("No default paragraph style!!");
            normal = Context.getWmlObjectFactory().createStyle();
            normal.setType("paragraph");
            normal.setStyleId("Normal");
            n = Context.getWmlObjectFactory().createStyleName();
            n.setVal("Normal");
            normal.setName(n);
            ((Styles)this.getJaxbElement()).getStyle().add(normal);
        }
        Style.BasedOn based = Context.getWmlObjectFactory().createStyleBasedOn();
        based.setVal(ROOT_NAME);
        normal.setBasedOn(based);
        ((Styles)this.getJaxbElement()).getStyle().add(this.styleDocDefaults);
        log.warn("Added virtual style, id '" + this.styleDocDefaults.getStyleId() + "', name '" + this.styleDocDefaults.getName().getVal() + "'");
        log.warn(XmlUtils.marshaltoString((Object)this.styleDocDefaults, true, true));
    }

    public Style getStyleById(String id) {
        for (Style s : ((Styles)this.getJaxbElement()).getStyle()) {
            if (!s.getStyleId().equals(id)) continue;
            return s;
        }
        return null;
    }

    public Style getDefaultCharacterStyle() {
        if (this.defaultCharacterStyle == null) {
            this.defaultCharacterStyle = this.getDefaultStyle("character");
        }
        if (this.defaultCharacterStyle == null) {
            try {
                this.defaultCharacterStyle = (Style)XmlUtils.unmarshalString(DEFAULT_CHARACTER_STYLE_DEFAULT);
                ((Styles)this.getJaxbElement()).getStyle().add(this.defaultCharacterStyle);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        return this.defaultCharacterStyle;
    }

    public Style getDefaultParagraphStyle() {
        if (this.defaultParagraphStyle == null) {
            this.defaultParagraphStyle = this.getDefaultStyle("paragraph");
        }
        if (this.defaultParagraphStyle == null) {
            for (Style s : ((Styles)this.getJaxbElement()).getStyle()) {
                if (!s.getType().equals("paragraph") || s.getName() == null || !s.getName().getVal().equals("Default")) continue;
                log.info("Style with name " + s.getName().getVal() + ", id '" + s.getStyleId() + "' is default " + s.getType() + " style");
                this.defaultParagraphStyle = s;
                break;
            }
        }
        if (this.defaultParagraphStyle == null) {
            for (Style s : ((Styles)this.getJaxbElement()).getStyle()) {
                if (!s.getType().equals("paragraph") || !s.getStyleId().equals("style0")) continue;
                log.info("Style with name " + s.getName().getVal() + ", id '" + s.getStyleId() + "' is default " + s.getType() + " style");
                this.defaultParagraphStyle = s;
                break;
            }
        }
        return this.defaultParagraphStyle;
    }

    public Style getDefaultTableStyle() {
        if (this.defaultTableStyle == null) {
            this.defaultTableStyle = this.getDefaultStyle("table");
        }
        return this.defaultTableStyle;
    }

    private Style getDefaultStyle(String type) {
        for (Style s : ((Styles)this.getJaxbElement()).getStyle()) {
            if (!s.isDefault() || !s.getType().equals(type)) continue;
            log.info("Style with name " + s.getName().getVal() + ", id '" + s.getStyleId() + "' is default " + s.getType() + " style");
            return s;
        }
        return null;
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
    }
}

