/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.relationships;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.docx4j.convert.out.flatOpcXml.FlatOpcXmlCreator;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.relationships.Relationships;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlteredParts {
    private static Logger log = LoggerFactory.getLogger(AlteredParts.class);

    public static Alterations start(WordprocessingMLPackage thisPackage, WordprocessingMLPackage otherPackage) throws Docx4JException {
        Alterations alterations = new Alterations();
        if (!thisPackage.getContentTypeManager().isContentEqual(otherPackage.getContentTypeManager())) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                thisPackage.getContentTypeManager().marshal(baos);
            }
            catch (JAXBException e) {
                throw new Docx4JException("Can't marshall content type", (Exception)((Object)e));
            }
        }
        RelationshipsPart packageRels = thisPackage.getRelationshipsPart();
        RelationshipsPart otherPackageRels = otherPackage.getRelationshipsPart();
        AlteredParts.recurse(alterations, packageRels, otherPackageRels);
        return alterations;
    }

    public static void recurse(Alterations alterations, RelationshipsPart thisRP, RelationshipsPart otherRP) throws Docx4JException {
        log.info("######### @" + thisRP.partName.getName() + "#########");
        log.info("uniques -------");
        List<Relationship> uniques = thisRP.uniqueToThis(otherRP);
        AlteredParts.addPartsForRels(alterations.getPartsAdded(), uniques, thisRP);
        List<Relationship> missings = thisRP.uniqueToOther(otherRP);
        AlteredParts.addPartsForRels(alterations.getPartsDeleted(), missings, otherRP);
        if (!thisRP.isContentEqual(otherRP)) {
            alterations.getPartsModified().add(new Alteration(thisRP, AlteredParts.toStorageFormat(thisRP)));
        }
        log.info("content -------");
        List<Relationship> altered = thisRP.differingContent(otherRP);
        AlteredParts.addPartsForRels(alterations.getPartsModified(), altered, thisRP);
        log.info("recurse ------- ");
        for (Relationship r : ((Relationships)thisRP.getJaxbElement()).getRelationship()) {
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) continue;
            if (uniques.contains(r)) {
                AlteredParts.addTree(alterations.getPartsAdded(), thisRP.getPart(r).getRelationshipsPart());
                continue;
            }
            if (missings.contains(r)) {
                AlteredParts.addTree(alterations.getPartsDeleted(), thisRP.getPart(r).getRelationshipsPart());
                continue;
            }
            Part thisPart = thisRP.getPart(r);
            Part otherPart = otherRP.getPart(RelationshipsPart.getRelationshipByTarget(otherRP, r.getTarget()));
            if (thisPart.getRelationshipsPart() == null) {
                if (otherPart.getRelationshipsPart() == null) continue;
                alterations.getPartsDeleted().add(new Alteration(thisPart.getPartName(), AlteredParts.toStorageFormat(thisPart.getRelationshipsPart())));
                AlteredParts.addTree(alterations.getPartsDeleted(), thisPart.getRelationshipsPart());
                continue;
            }
            if (otherPart.getRelationshipsPart() == null) {
                alterations.getPartsAdded().add(new Alteration(thisPart.getPartName(), AlteredParts.toStorageFormat(thisPart.getRelationshipsPart())));
                AlteredParts.addTree(alterations.getPartsAdded(), thisPart.getRelationshipsPart());
                continue;
            }
            AlteredParts.recurse(alterations, thisPart.getRelationshipsPart(), otherPart.getRelationshipsPart());
        }
    }

    private static void addPartsForRels(List<Alteration> list, List<Relationship> rels, RelationshipsPart rp) throws Docx4JException {
        for (Relationship r : rels) {
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
                log.debug(r.getTarget() + " is external");
                continue;
            }
            list.add(new Alteration(rp, AlteredParts.toStorageFormat(rp.getPart(r))));
            log.debug("added part: " + r.getTarget());
        }
    }

    private static void addTree(List<Alteration> list, RelationshipsPart rp) throws Docx4JException {
        if (rp == null) {
            return;
        }
        for (Relationship r : ((Relationships)rp.getJaxbElement()).getRelationship()) {
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
                log.debug(r.getTarget() + " is external");
                continue;
            }
            list.add(new Alteration(rp, AlteredParts.toStorageFormat(rp.getPart(r))));
            log.debug("add tree: " + r.getTarget());
            Part nextSourcePart = rp.getPart(r);
            RelationshipsPart nextRP = nextSourcePart.getRelationshipsPart();
            if (nextRP == null) continue;
            list.add(new Alteration(nextSourcePart.getPartName(), AlteredParts.toStorageFormat(nextRP)));
            AlteredParts.addTree(list, nextRP);
        }
    }

    private static org.docx4j.xmlPackage.Part toStorageFormat(Part part) throws Docx4JException {
        if (part instanceof BinaryPart) {
            log.info(".. saving binary stuff");
            return FlatOpcXmlCreator.createRawBinaryPart(part);
        }
        return FlatOpcXmlCreator.createRawXmlPart(part);
    }

    public static class Alteration {
        private PartName sourcePartName;
        private org.docx4j.xmlPackage.Part part;

        public PartName getSourcePartName() {
            return this.sourcePartName;
        }

        public org.docx4j.xmlPackage.Part getPart() {
            return this.part;
        }

        public Alteration(RelationshipsPart rp, org.docx4j.xmlPackage.Part part) {
            this.sourcePartName = rp.getSourceP().getPartName();
            this.part = part;
        }

        public Alteration(PartName sourcePartName, org.docx4j.xmlPackage.Part part) {
            this.sourcePartName = sourcePartName;
            this.part = part;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Alterations {
        private byte[] contentTypes;
        private List<Alteration> partsAdded = new ArrayList<Alteration>();
        private List<Alteration> partsDeleted = new ArrayList<Alteration>();
        private List<Alteration> partsModified = new ArrayList<Alteration>();

        public void setContentTypes(ByteArrayOutputStream baos) {
            this.contentTypes = baos.toByteArray();
        }

        public byte[] getContentTypes() {
            return this.contentTypes;
        }

        public List<Alteration> getPartsAdded() {
            return this.partsAdded;
        }

        public List<Alteration> getPartsDeleted() {
            return this.partsDeleted;
        }

        public List<Alteration> getPartsModified() {
            return this.partsModified;
        }

        public void debug() {
            System.out.println("- Additions -------");
            for (Alteration a : this.partsAdded) {
                System.out.println(a.getPart().getName() + " @ " + a.getSourcePartName().getName());
            }
            System.out.println("- Modifications -------");
            for (Alteration a : this.partsModified) {
                System.out.println(a.getPart().getName() + " @ " + a.getSourcePartName().getName());
            }
            System.out.println("- Deletions -------");
            for (Alteration a : this.partsDeleted) {
                System.out.println(a.getPart().getName() + " @ " + a.getSourcePartName().getName());
            }
        }

        public boolean isEmpty() {
            return this.partsAdded.isEmpty() && this.partsDeleted.isEmpty() && this.partsModified.isEmpty();
        }
    }
}

