% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{invertList}
\alias{invertList}
\title{Invert a 2-level list}
\usage{
invertList(l)
}
\arguments{
\item{l}{A list with 2 levels. If some levels are absent, they will be \code{NULL}}
}
\value{
A list with 2 levels deep, inverted from \code{l}
}
\description{
This is a simple version of \code{purrr::transpose}, only for lists with 2 levels.
}
\examples{
# create a 2-deep, 2 levels in first, 3 levels in second
a <- list(a = list(d = 1, e = 2:3, f = 4:6), b = list(d = 5, e = 55))
invertList(a) # creates 2-deep, now 3 levels outer --> 2 levels inner
}
