% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPage.R
\name{getPage}
\alias{getPage}
\title{Extract list of posts from a public Facebook page}
\usage{
getPage(page, token, n = 25, since = NULL, until = NULL, feed = FALSE,
  reactions = FALSE, verbose=TRUE)
}
\arguments{
\item{page}{A page ID or page name.}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth}.}

\item{n}{Number of posts of page to return. Note that number can be sometimes
higher or lower, depending on status of API.}

\item{since}{A UNIX timestamp or strtotime data value that points to
the start of the time range to be searched. For more information on the
accepted values, see: \url{http://php.net/manual/en/function.strtotime.php}}

\item{until}{A UNIX timestamp or strtotime data value that points to
the end of the time range to be searched. For more information on the
accepted values, see: \url{http://php.net/manual/en/function.strtotime.php}}

\item{feed}{If \code{TRUE}, the function will also return posts on the page
that were made by others (not only the admin of the page).}

\item{reactions}{If \code{TRUE}, will add variables to the data frame with
the total count of reactions: love, haha, wow, sad, angry.}

\item{verbose}{logical, default is \code{TRUE}, which will print additional
information on the console.}
}
\description{
\code{getPage} retrieves information from a public Facebook page. Note that
information about users that have turned on the "follow" option on their 
profile can also be retrieved with this function.
}
\details{
This function will only return information from public pages, not users
with public profiles.

The \code{since} and \code{until} parameters are applied to the \code{updated_time}
field in the post objects, and not the \code{created_time}. As a result, this function
might return old posts that have been updated recently.
}
\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
## Getting information about Facebook's Facebook Page
 load("fb_oauth")
 fb_page <- getPage(page="facebook", token=fb_oauth)
## Getting posts on Humans of New York page, including posts by others users
## (not only owner of page)
 page <- getPage(page="humansofnewyork", token=fb_oauth, feed=TRUE)
## Getting posts on Humans of New York page in January 2013
 page <- getPage(page="humansofnewyork", token=fb_oauth, n=1000,
   since='2013/01/01', until='2013/01/31')
}

}
\author{
Pablo Barbera \email{pablo.barbera@nyu.edu}
}
\seealso{
\code{\link{getUsers}}, \code{\link{getPost}}, \code{\link{fbOAuth}}
}

