% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rclust.hclust.R
\name{rclust.hclust}
\alias{rclust.hclust}
\title{Hierarchical Agglomerative Clustering for Manifold-valued Data}
\usage{
rclust.hclust(
  input,
  type = c("extrinsic", "intrinsic"),
  method = c("single", "complete", "average", "mcquitty", "ward.D", "ward.D2",
    "centroid", "median"),
  members = NULL
)
}
\arguments{
\item{input}{a S3 object of \code{riemdata} class. See \code{\link[RiemBase]{riemfactory}} for more details.}

\item{type}{type of distance, either \code{"intrinsic"} or \code{"extrinsic"}.}

\item{method}{the agglomeration method to be used. This must be (an unambiguous abbreviation of) one of \code{"single"},
\code{"complete"}, \code{"average"}, \code{"mcquitty"}, \code{"ward.D"}, \code{"ward.D2"}, \code{"centroid"} or \code{"median"}.}

\item{members}{\code{NULL} or a vector whose length equals the number of observations. See \code{\link[stats]{hclust}} for details.}
}
\value{
an object of class \code{hclust}. See \code{\link[stats]{hclust}} for details.
}
\description{
Hierarchical clustering is a generally applicable clustering algorithm 
as long as we have concept of dissimilarity. We adopt \code{hclust} algorithm 
by \pkg{fastcluster} package. See \code{\link[fastcluster]{hclust}} for more details.
}
\examples{
## generate 50 points near (0,0,1)  and
##          50 points near (0,0,-1) on Sphere S^2 
ndata = 50
theta = seq(from=-0.99,to=0.99,length.out=ndata)*pi
tmpx  = cos(theta) + rnorm(ndata,sd=0.1)
tmpy  = sin(theta) + rnorm(ndata,sd=0.1)

## wrap it as 'riemdata' class
data  = list()
for (i in 1:ndata){
  tgt = c(tmpx[i],tmpy[i],1)
  data[[i]] = tgt/sqrt(sum(tgt^2)) # project onto Sphere
}
for (i in 1:ndata){
  tgt = c(tmpx[i],tmpy[i],-1)
  data[[i+ndata]] = tgt/sqrt(sum(tgt^2)) # project onto Sphere
}
data = RiemBase::riemfactory(data, name="sphere")

## compare extrinsic and intrinsic hierarchical clustering
hext <- rclust.hclust(data, type="extrinsic")
hint <- rclust.hclust(data, type="intrinsic")

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2), pty="s")
plot(hext, main="extrinsic+single")
plot(hint, main="intrinsic+single")
par(opar)

}
\references{
\insertRef{mullner_fastcluster_2013}{RiemBaseExt}
}
