% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/media.R
\name{ig_edit_media_caption}
\alias{ig_edit_media_caption}
\title{Edit a Post's Caption}
\usage{
ig_edit_media_caption(media_id, caption_text, verbose = FALSE)
}
\arguments{
\item{media_id}{numeric; the unique id to identify a post which can be 
found in the \code{id}, not the \code{pk} field, of posts returned via many of 
the functions retrieving feeds.}

\item{caption_text}{character; the text below a post's image or video.}

\item{verbose}{logical; do you want informative messages?}
}
\description{
This function can be used to edit the caption of a post that has already been made.
}
\examples{
\donttest{
last_post_media_id <- ig_my_timeline(paginate = FALSE)$id[1]
edit_result <- ig_edit_media_caption(last_post_media_id, 
                                     caption_text = "New, Edited Caption")
}
}
