% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{utils}
\alias{utils}
\alias{rmse}
\alias{freq}
\alias{cronbach_alpha}
\alias{spearman_brown}
\alias{spearman_brown_reverse}
\alias{quadratic_kappa}
\title{Utility functions}
\usage{
rmse(x1, x2)

freq(x, vals = NULL, decimal = NULL)

cronbach_alpha(u)

spearman_brown(rho, n_len)

spearman_brown_reverse(rho, target_rho)

quadratic_kappa(x1, x2)
}
\arguments{
\item{x1}{a numeric vector or matrix}

\item{x2}{a numeric vector or matrix}

\item{x}{a numeric or character vector}

\item{vals}{valid values, \code{NULL} to include all values}

\item{decimal}{round results to n-th decimal places}

\item{u}{oberved responses, 2d matrix}

\item{rho}{the reliability of the current test}

\item{n_len}{extend the test to n times longer}

\item{target_rho}{the targeted reliability}
}
\value{
\code{freq} returns the frequency counts and percentages in a data.frame
}
\description{
\code{rmse} computes the root mean squared error (RMSE) 
of two numeric vectors/matrices

\code{freq} computes the frequency counts of 
a numeric or character vector

\code{cronbach_alpha} computes the Cronbach's alpha 
internal consistency reliability index

\code{spearman_brown} predicts the reliability when the 
current test is extended to n times longer

\code{spearman_brown_reverse} computes how many times
the current test length needs to be extended in order to reach targeted
reliability

\code{quadratic kappa} computes the quadratic weighted kappa
of two numeric vectors
}
\examples{
rmse(rnorm(10), rnorm(10))
freq(round(runif(100, 1, 5)))
cronbach_alpha(model_3pl_gendata(1000, 20)$u)
spearman_brown(.70, 2)
spearman_brown_reverse(.70, .85)
quadratic_kappa(round(runif(100, 1, 5)), round(runif(100, 1, 5)))
}
