% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsolve_CHEBY.R
\name{lsolve.cheby}
\alias{lsolve.cheby}
\title{Chebyshev Method}
\usage{
lsolve.cheby(A, B, xinit = NA, reltol = 1e-05, maxiter = 10000,
  preconditioner = diag(ncol(A)), adjsym = TRUE, verbose = TRUE)
}
\arguments{
\item{A}{an \code{(m-by-n)} dense or sparse matrix. See also \code{\link[Matrix]{sparseMatrix}}.}

\item{B}{a vector of length \code{m} or an \code{(m-by-k)} matrix (dense or sparse) for solving \code{k} systems simultaneously.}

\item{xinit}{a length-\code{n} vector for initial starting point. \code{NA} to start from a random initial point near 0.}

\item{reltol}{tolerance level for stopping iterations.}

\item{maxiter}{maximum number of iterations allowed.}

\item{preconditioner}{an \code{(n-by-n)} preconditioning matrix; default is an identity matrix.}

\item{adjsym}{a logical; \code{TRUE} to symmetrize the system by transforming the system into normal equation, \code{FALSE} otherwise.}

\item{verbose}{a logical; \code{TRUE} to show progress of computation.}
}
\value{
a named list containing \describe{
\item{x}{a solution of length \code{n}.}
\item{iter}{the number of iterations required.}
\item{errors}{a vector of errors for stopping criterion.}
}
}
\description{
Chebyshev method - also known as Chebyshev iteration - avoids computation of inner product,
enabling distributed-memory computation to be more efficient at the cost of requiring
a priori knowledge on the range of spectrum for matrix \code{A}.
}
\examples{
## Overdetermined System
A = matrix(rnorm(10*5),nrow=10)
x = rnorm(5)
b = A\%*\%x

out1 = lsolve.sor(A,b,w=0.5)
out2 = lsolve.cheby(A,b)
matout = cbind(x, out1$x, out2$x);
colnames(matout) = c("original x","SOR result", "Chebyshev result")
print(matout)

}
\references{
\insertRef{gutknecht_chebyshev_2002}{Rlinsolve}
}
