% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbal_oil_forecast.R
\name{mbal_forecast_param_oil}
\alias{mbal_forecast_param_oil}
\title{A list object of class 'forecast_oil' for material balance analysis}
\usage{
mbal_forecast_param_oil(
  input_unit = "Field",
  output_unit = "Field",
  N = NULL,
  m = NULL,
  phi = NULL,
  swi = NULL,
  Gi = NULL,
  pb = NULL,
  p = NULL,
  pvt = NULL,
  cf = NULL,
  wf = NULL,
  sorg = NULL,
  rel_perm = NULL
)
}
\arguments{
\item{input_unit}{a unit system for parameters, only the character string 'Field' is accepted}

\item{output_unit}{a unit system for properties, only the character string 'Field' is accepted}

\item{N}{original oil in place, STB}

\item{m}{ratio of original gas cap volume to original oil leg volume, a numeric fraction}

\item{phi}{reservoir porosity, a numeric fraction}

\item{swi}{initial water saturation in the reservoir, a numeric fraction}

\item{Gi}{cumulative gas injection, SCF}

\item{pb}{bubble point pressure, a numeric value, psi}

\item{p}{reservoir pressure, a numeric vector, psi}

\item{pvt}{a data frame of PVT properties including pressure 'p' in 'psi', oil formation volume factor 'Bo' in 'bbl/stb', solution gas-oil ratio 'Rs' in 'scf/stb', oil viscosity 'muo' in 'cp', volatilized oil-gas ratio 'Rv' in 'stb/scf', gas formation volume factor 'Bg' in 'bbl/scf', gas viscosity 'mug' in 'cp', water formation volume factor 'Bw' in 'bbl/stb', and water viscosity 'muw' in 'cp'}

\item{cf}{formation compressibility, a numeric value or vector, 1/psi}

\item{wf}{weight factor, a numeric vector of zeros and ones. A zero value excludes the entire row of reservoir history data at a particular time from the material balance analysis}

\item{sorg}{residual oil saturation in gas invaded zone (gas cap expansion or gas injection), a numeric fraction}

\item{rel_perm}{a data frame with four columns: gas saturation 'Sg', liquid saturation 'Sl', gas relative permeability 'Krg', and oil relative permeability 'Krog'}
}
\value{
a list of class ’forecast_oil’ with all the required parameters for the mbal_forecast_oil() S3 methods
}
\description{
Create an object of class 'forecast_oil'
}
\examples{
p_pvt <- c(3330, 3150, 3000, 2850, 2700, 2550, 2400)

Bo <- c(1.2511, 1.2353, 1.2222, 1.2122, 1.2022, 1.1922, 1.1822)

Rs <- c(510, 477, 450, 425, 401, 375, 352)

Bg <- c(0.00087, 0.00092, 0.00096, 0.00101, 0.00107, 0.00113, 0.00120)

cw <- 2e-6

Bwi <- 1.0

Bw <- Bwi * exp(cw * (p_pvt[1] - p_pvt))

Rv <- rep(0, length(p_pvt))

muo <- rep(0.5, length(p_pvt))

muw <- rep(0.25, length(p_pvt))

mug <- rep(0.02, length(p_pvt))

pvt_table <- data.frame(p = p_pvt, Bo = Bo, Rs = Rs, Rv = Rv, Bg = Bg,
                       Bw = Bw, muo = muo, mug = mug, muw = muw)

rel_perm <- as.data.frame(Rrelperm::kr2p_gl(SWCON = 0.2, SOIRG = 0.10,
SORG = 0.10, SGCON = 0.05, SGCRIT = 0.05, KRGCL = 0.3, KROGCG = 1,
NG = 0.93, NOG = 10, NP = 101))

colnames(rel_perm) <- c("Sg", "Sl", "Krg", "Krog")

p <- c(3330, 3150, 3000, 2850, 2700, 2550, 2400)

Gi <- rep(0, length.out = length(p))

wf <- c(1, 1, 1, 0, 1, 0, 1)

forecast_lst <- mbal_forecast_param_oil(input_unit = "Field",
output_unit = "Field", N = 1.37e8, m = 0.377, phi = 0.2, swi = 0.2, Gi = Gi,
pb = 3330, p = p, pvt = pvt_table, cf = 0, wf = wf, sorg = 0.2,
rel_perm = rel_perm)

dplyr::glimpse(forecast_lst)
}
