% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchParams.R
\name{searchParams}
\alias{searchParams}
\title{searchParams}
\description{
An alternative way to specify a query is by creating a searchParams object
and pass this to the \code{\link[=fhirClient]{fhirClient's}} searchByQuery. The searchParams class has a set of fluent calls to allow you
to easily construct more complex queries.
Based on \href{https://github.com/ewoutkramer/fhir-net-api}{the official HL7 FHIR .NET API.}
}
\section{Usage}{

\preformatted{
query <- searchParams$new()

query$select(elements)
query$where(criteria)
query$include(path)
query$orderBy(paramName, sortOrder = "asc")
query$limitTo(count)
query$countOnly()
query$summaryOnly()
query$textOnly()
query$dataOnly()
}
}

\section{Arguments}{

\describe{
  \item{query}{A \code{searchParams} object that contains all specified search criteria.}
  \item{elements}{Elements defined at the root level in the Resource.}
  \item{criteria}{The search parameters to filter the Resources on. Each given string is a combined key/value pair (separated by '=').}
  \item{path}{Paths to include in the search.}
  \item{paramName}{Name of the parameter to order by.}
  \item{sortOrder}{Direction of the order. Can be asc or desc (ascending and descending).}
  \item{count}{The number of returned Resources per page.}
}
}

\section{Details}{

\code{$new()} Creates a new searchParams object.

\code{$select()} Specify the elements to be returned as part of a Resource.

\code{$where()} Specify on which parameters to filter.

\code{$include()} Specify the paths to include.

\code{$orderBy()} Specify the order to return the results.

\code{$limitTo()} Specify how many Resources should be returned in a single page of a Bundle.

\code{$countOnly()} Specifiy to just return a count of the matching Resources, without returning the actual matches.

\code{$summaryOnly()} Specify to return only those elements marked as "summary" in the base definition of the Resource(s).

\code{$textOnly()} Specify to return only the "text" element, the 'id' element, the 'meta' element, and only top-level mandatory elements.

\code{$dataOnly()} Specify to remove the text element.
}

\examples{
\dontrun{
# Setting up a fhirClient
client <- fhirClient$new("http://vonk.furore.com")

# Creating a new searchParams object
query <- searchParams$new()
query$select(c("name", "birthDate"))$where("given:exact=Peter")$orderBy("family")


peters <- client$searchByQuery(query, "Patient")
# equivalent:
# client$search("Patient", c("_elements=name,birthDate","given:exact=Peter", "_sort=family"))

while(!is.null(bundle)){
   # Do something useful
   peters <- client$continue(peters)
}
}
}
