\name{BC.IND.relation.RST}
\alias{BC.IND.relation.RST}
\title{Indiscernibility relation based on rough set theory}
\usage{
BC.IND.relation.RST(decision.table, attribute = NULL)
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing a decision table. See
  \code{\link{SF.asDecisionTable}}.}

  \item{attribute}{a numerical vector expressing indexes of
  subsets of attributes to be considered. The default value
  is \code{NULL} which means that all condition attributes
  will be considered. It should be noted that in this case,
  all attributes considered should be nominal attributes,
  otherwise discretization must be performed first.}
}
\value{
A class \code{"IndiscernibilityRelation"} which contains
\itemize{ \item \code{IND.relation}: a list representing
indiscernibility relation over all objects.  \item
\code{type.relation}: it is \code{"equivalence"}.  \item
\code{type.model}: a string showing the type of model which
is used. In this case, it is \code{"RST"} which means rough
set theory.  }
}
\description{
This is a function implementing a fundamental part of RST:
the indiscernibility relation. The indiscernibility
relation is a binary relation showing whether two objects
can be discerned. The detailed description based on
theoritical point of view can be seen in
\code{\link{A.Introduction-RoughSets}}.
}
\details{
This function is used as a basic function and is needed by
other functions such as
\code{\link{BC.LU.approximation.RST}},
\code{\link{BC.positive.reg.RST}} for calculating lower and
upper approximations and determining the positive region.
The formula of the indiscernibility relation has been
explained in \code{\link{A.Introduction-RoughSets}}.
}
\examples{
#############################################
## Example 1: Using simple data set
## Objects must be nominal/symbolic values
## Otherwise, we must use discretization first
#############################################
## Construct decision table as data frame
dt.ex1 <- data.frame(c(1,0,2,1,1,2,2,0), c(0, 1,0, 1,0,2,1,1),
                        c(2,1,0,0,2,0,1,1), c(2,1,1,2,0,1,1,0), c(0,2,1,2,1,1,2,1))
colnames(dt.ex1) <- c("aa", "bb", "cc", "dd", "ee")
decision.table <- SF.asDecisionTable(dataset = dt.ex1, decision.attr = 5,
                                     indx.nominal = c(1:5))

## In this case, we only consider the second and third attributes.
P <- c(2,3)

####### Perform indiscernibility relation #######
IND <- BC.IND.relation.RST(decision.table, attribute = P)
}
\references{
Z. Pawlak, "Rough Sets", International Journal of Computer
and Information Sciences, vol. 11, no. 5, p. 341 - 356
(1982).
}
\seealso{
\code{\link{BC.LU.approximation.RST}},
\code{\link{BC.LU.approximation.RST}}
}

