% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/FeatureSelection.R
\name{FS.quickreduct.RST}
\alias{FS.quickreduct.RST}
\title{QuickReduct algorithm based on RST}
\usage{
FS.quickreduct.RST(decision.table, control = list())
}
\arguments{
\item{decision.table}{an object of a \code{"DecisionTable"} class representing a decision table. See \code{\link{SF.asDecisionTable}}.}

\item{control}{other parameters. It contains the following component:
       \itemize{
       \item \code{randomize}: it has a boolean value. For the detailed description, see in Section \code{Details}.
             The default value is \code{FALSE}.
       }}
}
\value{
A class \code{"FeatureSubset"} that contains the following components:
\itemize{
\item \code{reduct}: a list representing single reduct. In this case, it could be super reduct or just subset of feature.
\item \code{type.method}: a string representing a type of method which is \code{"quickreduct"}.
\item \code{type.task}: a string showing type of task which is \code{"feature selection"}.
\item \code{model}: a string representing a type of model. In this case, it is \code{"RST"} which means rough set theory.
}
}
\description{
This is a function for implementing the QuickReduct algorithm for feature selection based
on RST proposed by (Shen and Chouchoulas, 2000). The algorithm produces only one feature subset that could be a superreduct.
}
\details{
This algorithm considers the dependency degree (see \code{\link{A.Introduction-RoughSets}})
of the addition of each attribute to the current reduct candidate. Then the best candidate will be chosen.
This process continues until the dependency of the subset equals to the dependency of the full dataset.

Additionally, in \code{control} parameter, we provide one component which is
\code{randomize}. It has a boolean value: \code{TRUE} or \code{FALSE} that means we want to perform
quickreduct by evaluating attributes randomly or all attributes in decision table.

It should be noted that this function does not give the new decision table directly.
The other additional function called \code{\link{SF.applyDecTable}} is used to produce new decision table based on
information about the reduct from this function.
}
\examples{
###################################################
## Example 1: Evaluate reduct and generate
##            new decision table
###################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## evaluate single reduct
res.1 <- FS.quickreduct.RST(decision.table)

## generate new decision table according to the reduct
new.decTable <- SF.applyDecTable(decision.table, res.1)
}
\author{
Lala Septem Riza
}
\references{
Q. Shen and A. Chouchoulas, "A Modular Approach to Generating Fuzzy Rules with Reduced Attributes for the Monitoring of Complex Systems",
Engineering Applications of Artificial Intelligence, vol. 13, p. 263 - 278 (2000).
}
\seealso{
\code{\link{FS.quickreduct.FRST}}
}

