% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FeatureSelection.R
\name{FS.feature.subset.computation}
\alias{FS.feature.subset.computation}
\title{The superreduct computation based on RST and FRST}
\usage{
FS.feature.subset.computation(decision.table,
  method = "greedy.heuristic.superreduct", ...)
}
\arguments{
\item{decision.table}{an object of a \code{"DecisionTable"} class representing a decision table. See \code{\link{SF.asDecisionTable}}.}

\item{method}{a character representing the type of a method to use for computations. See in Section \code{Details}.}

\item{...}{other parameters corresponding to the chosen \code{method}.}
}
\value{
A class \code{"FeatureSubset"}.
}
\description{
This function is a wrapper for computing different types of decision superreducts
(i.e. attribute subsets which do not lose any information regarding the decisions
but are not require to be irreducable).
}
\details{
Currently, there are implemented three methods that can be used with this function:
\itemize{
\item \code{"greedy.heuristic.superreduct"}: it is a greedy heuristic method which employs several quality measures from RST.
           See \code{\link{FS.greedy.heuristic.superreduct.RST}}.
\item \code{"quickreduct.frst"}: it is a feature selection function based on the fuzzy QuickReduct algorithm on FRST.
           See \code{\link{FS.quickreduct.FRST}}.
\item \code{"quickreduct.rst"}: it is a feature selection function based on the RST QuickReduct algorithm.
           See \code{\link{FS.quickreduct.RST}}.
}
These methods can be selected by assigning an appropriate value of the parameter \code{method}.
Additionally, \code{\link{SF.applyDecTable}} is provided to generate the new decision table.
}
\examples{
###############################################################
## Example 1: generate reduct and new decision table using RST
###############################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## generate single superreduct
res.1 <- FS.feature.subset.computation(decision.table,
                                       method = "quickreduct.rst")

## generate new decision table according to the reduct
new.decTable <- SF.applyDecTable(decision.table, res.1)

###############################################################
## Example 2: generate reduct and new decision table using FRST
###############################################################
data(RoughSetData)
decision.table <- RoughSetData$housing7.dt

## generate single superreduct
res.2 <- FS.feature.subset.computation(decision.table,
                                       method = "quickreduct.frst")

## generate new decision table according to the reduct
new.decTable <- SF.applyDecTable(decision.table, res.2)
}
\author{
Andrzej Janusz
}
\seealso{
\code{\link{FS.greedy.heuristic.superreduct.RST}}, \code{\link{FS.quickreduct.RST}}, \code{\link{FS.quickreduct.FRST}}.
}

