% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{vital_rate_exprs.pdb_proto_ipm_list}
\alias{vital_rate_exprs.pdb_proto_ipm_list}
\alias{vital_rate_exprs.pdb_ipm}
\alias{kernel_formulae.pdb_proto_ipm_list}
\alias{kernel_formulae.pdb_ipm}
\alias{domains.pdb_proto_ipm_list}
\alias{domains.pdb_ipm}
\alias{parameters.pdb_proto_ipm_list}
\alias{parameters.pdb_ipm}
\alias{pop_state.pdb_proto_ipm_list}
\alias{pop_state.pdb_ipm}
\alias{vital_rate_funs.pdb_ipm}
\alias{int_mesh.pdb_ipm}
\alias{lambda.pdb_ipm}
\alias{right_ev.pdb_ipm}
\alias{left_ev.pdb_ipm}
\alias{is_conv_to_asymptotic.pdb_ipm}
\alias{conv_plot.pdb_ipm}
\alias{make_iter_kernel.pdb_ipm}
\alias{mean_kernel.pdb_ipm}
\alias{pdb_new_fun_form}
\alias{parameters<-.pdb_proto_ipm_list}
\alias{vital_rate_exprs<-.pdb_proto_ipm_list}
\alias{kernel_formulae<-.pdb_proto_ipm_list}
\alias{[.pdb_ipm}
\title{Padrino methods for `ipmr` generic functions}
\usage{
\method{vital_rate_exprs}{pdb_proto_ipm_list}(object)

\method{vital_rate_exprs}{pdb_ipm}(object)

\method{kernel_formulae}{pdb_proto_ipm_list}(object)

\method{kernel_formulae}{pdb_ipm}(object)

\method{domains}{pdb_proto_ipm_list}(object)

\method{domains}{pdb_ipm}(object)

\method{parameters}{pdb_proto_ipm_list}(object)

\method{parameters}{pdb_ipm}(object)

\method{pop_state}{pdb_proto_ipm_list}(object)

\method{pop_state}{pdb_ipm}(object)

\method{vital_rate_funs}{pdb_ipm}(ipm)

\method{int_mesh}{pdb_ipm}(ipm, full_mesh = TRUE)

\method{lambda}{pdb_ipm}(ipm, ...)

\method{right_ev}{pdb_ipm}(ipm, iterations = 100, tolerance = 1e-10, ...)

\method{left_ev}{pdb_ipm}(ipm, iterations = 100, tolerance = 1e-10, ...)

\method{is_conv_to_asymptotic}{pdb_ipm}(ipm, tolerance = 1e-10)

\method{conv_plot}{pdb_ipm}(ipm, iterations = NULL, log = FALSE, show_stable = TRUE, ...)

\method{make_iter_kernel}{pdb_ipm}(ipm, ..., name_ps = NULL, f_forms = NULL)

\method{mean_kernel}{pdb_ipm}(ipm)

pdb_new_fun_form(...)

\method{parameters}{pdb_proto_ipm_list}(object, ...) <- value

\method{vital_rate_exprs}{pdb_proto_ipm_list}(object, kernel = NULL, vital_rate = NULL) <- value

\method{kernel_formulae}{pdb_proto_ipm_list}(object, kernel) <- value

\method{[}{pdb_ipm}(x, i)
}
\arguments{
\item{object}{An object produced by \code{pdb_make_proto_ipm} or
\code{pdb_make_ipm}.}

\item{ipm}{A \code{pdb_ipm}.}

\item{full_mesh}{Logical. Return the complete set of meshpoints or only the
unique ones.}

\item{...}{Usage depends on the function - see Details and Examples.}

\item{iterations}{The number of times to iterate the model to reach
convergence. Default is 100.}

\item{tolerance}{Tolerance to evaluate convergence to asymptotic dynamics.}

\item{log}{Log-transform lambdas for plotting?}

\item{show_stable}{Show horizontal line denoting stable population growth?}

\item{name_ps}{For \code{pdb_ipm} objects that contain \code{age_x_size} IPMs,
a named list. The names of the list should be the \code{ipm_id}s that are
\code{age_x_size} models, and the values in the list should be the the name
of the survival/growth kernels.}

\item{f_forms}{For \code{pdb_ipm} objects that contain \code{age_x_size} IPMs,
a named list. The names of the list should be the \code{ipm_id}s that are
\code{age_x_size} models, and the values in the list should be the the name
of the fecundity kernels. If multiple sub-kernels contribute to fecundity, we
can also supply a string specifying how they are combined (e.g.
\code{f_forms = "F + C"}).}

\item{value}{The value to insert. See details and Examples.}

\item{kernel}{Ignored, present for compatibility with \code{ipmr}.}

\item{vital_rate}{Ignored, present for compatibility with \code{ipmr}.}

\item{x}{A \code{pdb_ipm} object.}

\item{i}{The index to extract}
}
\value{
Most of these return named lists where names correspond to
\code{ipm_ids}. The exception is \code{pdb_new_fun_form}, which returns a list
of expressions. It is only intended for setting new expressions with
\code{vital_rate_exprs<-}.
}
\description{
Provides wrappers around \code{ipmr} generic functions to extract
some quantities of interest from \code{pdb_proto_ipm_list}s and \code{pdb_ipm}s.
}
\details{
There are number of uses for \code{...} which depend on the function
used for them. These are described below.
}
\section{\code{pdb_new_fun_form}}{


This must be used when setting new expressions for
vital rates and kernel formulae. The \code{...} argument should be a named list
of named lists. The top most layer should be \code{ipm_id}'s. The next layer
should be a list where the names are vital rates you wish to modify, and the
values are the expressions you want to insert. See examples.
}

\section{\code{make_iter_kernel}}{


The \code{...} here should be expressions representing the block kernel of
the IPMs in question. The names of each expression should be the ipm_id,
and the expressions should take the form of \code{c(<upper_left>,
<upper_right>, <lower_left>, <lower_right>)}
(i.e. a vector of symbols would create a matrix in row-major order).
See examples.
}

\section{\code{conv_plot}/\code{lambda}}{


The \code{...} are used pass additional arguments to \code{\link[ipmr]{lambda}}
and \code{\link[ipmr]{conv_plot}}.
}

\examples{

data(pdb)
my_pdb <- pdb_make_proto_ipm(pdb, c("aaaa17", "aaa310"))

# These values will be appended to the parameter list for each IPM, as they
# aren't currently present in them.

parameters(my_pdb) <- list(
  aaa310 = list(
    g_slope_2 = 0.0001,
    establishment_prob = 0.02
  ),
  aaaa17 = list(
    g_var = 4.2,
    germ_prob = 0.3
  )
)

# We can overwrite a parameter value with a new one as well. Old values aren't
# saved anywhere except in the pdb object, so be careful!

parameters(my_pdb) <- list(
  aaa310 = list(
    s_s    = 0.93, # old value is 0.92
    gvar_i = 0.13 # old value is 0.127
  )
)

vital_rate_exprs(my_pdb) <- pdb_new_fun_form(
    list(
      aaa310 = list(mu_g = g_int + g_slope * size_1 + g_slope_2 * size_1^2),
      aaaa17 = list(sigmax2 = sqrt(g_var * exp(cfv1 + cfv2 * size_1))
     )
   )
 )

 kernel_formulae(my_pdb) <- pdb_new_fun_form(
   list(
     aaaa17 = list(Y = recr_size * yearling_s * germ_prob * d_size),
     aaa310 = list(F = f_n * f_d * establishment_prob)
   )
 )

 my_ipms    <- pdb_make_ipm(my_pdb)
 iter_kerns <- make_iter_kernel(my_ipms, aaaa17 = c(0, F_yr, Y, P_yr))

}
