% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deals.get_all.R
\name{deals.get_all}
\alias{deals.get_all}
\title{Get all deals}
\usage{
deals.get_all(user_id = NULL, filter_id = NULL, stage_id = NULL,
  status = NULL, start = NULL, limit = NULL, sort = NULL,
  owned_by_you = NULL, api_token = NULL, company_domain = "api")
}
\arguments{
\item{user_id}{If supplied, only deals matching the given user will be returned.}

\item{filter_id}{ID of the filter to use}

\item{stage_id}{If supplied, only deals within the given stage will be returned.}

\item{status}{Only fetch deals with specific status. If omitted, all not deleted deals are fetched. This field has the following domains: (open; won; lost; deleted; all_not_deleted)}

\item{start}{Pagination start}

\item{limit}{Items shown per page. Default limit is 100, maximum limit is 500.}

\item{sort}{Field names and sorting mode separated by a comma (field_name_1 ASC, field_name_2 DESC). Only first-level field keys are supported (no nested keys).}

\item{owned_by_you}{When supplied, only deals owned by you are returned. However filter_id takes precedence over owned_by_you when both are supplied. This field has the following domains: (0; 1)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Get all deals from pipedrive.
}
\examples{
\donttest{
deals.get_all(api_token='token',company_domain='exp')
}
}
