% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deals.add.products.R
\name{deals.add.products}
\alias{deals.add.products}
\title{Add a product to the deal, eventually creating a new item called a deal-product.}
\usage{
deals.add.products(id, product_id, item_price, quantity,
  discount_percentage = NULL, duration = NULL,
  product_variation_id = NULL, comments = NULL, enabled_flag = NULL,
  api_token = NULL, company_domain = "api",
  return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the deal}

\item{product_id}{ID of the product that will be attached}

\item{item_price}{Price at which this product will be added to the deal}

\item{quantity}{Quantity  e.g. how many items of this product will be added to the deal}

\item{discount_percentage}{Discount percent. If omitted, will be set to 0}

\item{duration}{Duration of the product (when product durations are not enabled for the company or if omitted, defaults to 1)}

\item{product_variation_id}{ID of the product variation to use. When omitted, no variation will be used.}

\item{comments}{Any textual comment associated with this product-deal attachment. Visible and editable in the application UI.}

\item{enabled_flag}{Whether the product is enabled on the deal or not. This makes it possible to add products to a deal with specific price and discount criteria - but keep them disabled, which refrains them from being included in deal price calculation. When omitted, the product will be marked as enabled by default. This field has the following domains: (0; 1)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Add a product to the deal, eventually creating a new item called a deal-product. on pipedrive.
}
\examples{
\donttest{
deals.add.products(id='e.g.',product_id='e.g.',item_price='e.g.',quantity='e.g.')
}
}
