% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.get_all.R
\name{notes.get_all}
\alias{notes.get_all}
\title{Get all notes}
\usage{
notes.get_all(user_id = NULL, deal_id = NULL, person_id = NULL,
  org_id = NULL, start = NULL, limit = NULL, sort = NULL,
  start_date = NULL, end_date = NULL, pinned_to_deal_flag = NULL,
  pinned_to_organization_flag = NULL, pinned_to_person_flag = NULL,
  api_token = NULL, company_domain = "api")
}
\arguments{
\item{user_id}{ID of the user whose notes to fetch. If omitted, notes by all users will be returned.}

\item{deal_id}{ID of the deal which notes to fetch. If omitted, notes about all deals with be returned.}

\item{person_id}{ID of the person whose notes to fetch. If omitted, notes about all persons with be returned.}

\item{org_id}{ID of the organization which notes to fetch. If omitted, notes about all organizations with be returned.}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{sort}{Field names and sorting mode separated by a comma (field_name_1 ASC, field_name_2 DESC). Only first-level field keys are supported (no nested keys). Supported fields: id, user_id, deal_id, person_id, org_id, content, add_time, update_time.}

\item{start_date}{Date in format of YYYY-MM-DD from which notes to fetch from.}

\item{end_date}{Date in format of YYYY-MM-DD until which notes to fetch to.}

\item{pinned_to_deal_flag}{If set, then results are filtered by note to deal pinning state. This field has the following domains: (0; 1)}

\item{pinned_to_organization_flag}{If set, then results are filtered by note to organization pinning state. This field has the following domains: (0; 1)}

\item{pinned_to_person_flag}{If set, then results are filtered by note to person pinning state. This field has the following domains: (0; 1)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Get all notes from pipedrive.
}
\examples{
\donttest{
notes.get_all(api_token='token',company_domain='exp')
}
}
