% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations.get.deals.R
\name{organizations.get.deals}
\alias{organizations.get.deals}
\title{List deals associated with an organization}
\usage{
organizations.get.deals(id, start = NULL, limit = NULL,
  status = NULL, sort = NULL, only_primary_association = NULL,
  api_token = NULL, company_domain = "api")
}
\arguments{
\item{id}{ID of an organization}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{status}{Only fetch deals with specific status. If omitted, all not deleted deals are fetched. This field has the following domains: (open; won; lost; deleted; all_not_deleted)}

\item{sort}{Field names and sorting mode separated by a comma (field_name_1 ASC, field_name_2 DESC). Only first-level field keys are supported (no nested keys).}

\item{only_primary_association}{If set, only deals that are directly associated to the organization are fetched. If not set (default), all deals are fetched that are either directly or indirectly related to the organization. Indirect relations include relations through custom, organization-type fields and through persons of the given organization. This field has the following domains: (0; 1)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to List deals associated with an organization from pipedrive.
}
\examples{
\donttest{
organizations.get.deals(id='e.g.',api_token='token',company_domain='exp')
}
}
