% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{update_classes_dp}
\alias{update_classes_dp}
\title{Dirichlet process-based update of latent classes}
\usage{
update_classes_dp(
  Cmax,
  beta,
  z,
  b,
  Omega,
  delta,
  xi,
  D,
  nu,
  Theta,
  s_desc = TRUE
)
}
\arguments{
\item{Cmax}{The maximum number of classes.}

\item{beta}{The matrix of the decision-maker specific coefficient vectors of dimension
\code{P_r} x \code{N}.
Set to \code{NA} if \code{P_r = 0}.}

\item{z}{The vector of the allocation variables of length \code{N}.
Set to \code{NA} if \code{P_r = 0}.}

\item{b}{The matrix of class means as columns of dimension \code{P_r} x \code{C}.
Set to \code{NA} if \code{P_r = 0}.}

\item{Omega}{The matrix of class covariance matrices as columns of dimension
\code{P_r*P_r} x \code{C}.
Set to \code{NA} if \code{P_r = 0}.}

\item{delta}{A numeric for the concentration parameter vector \code{rep(delta,C)} of the
Dirichlet prior for \code{s}.
Per default, \code{delta = 1}. In case of Dirichlet process-based updates of the
latent classes, \code{delta = 0.1} per default.}

\item{xi}{The mean vector of length \code{P_r} of the normal prior for each \code{b_c}.
Per default, \code{xi = numeric(P_r)}.}

\item{D}{The covariance matrix of dimension \code{P_r} x \code{P_r} of the normal prior for
each \code{b_c}.
Per default, \code{D = diag(P_r)}.}

\item{nu}{The degrees of freedom (a natural number greater than \code{P_r}) of the Inverse
Wishart prior for each \code{Omega_c}.
Per default, \code{nu = P_r + 2}.}

\item{Theta}{The scale matrix of dimension \code{P_r} x \code{P_r} of the Inverse Wishart prior for
each \code{Omega_c}.
Per default, \code{Theta = diag(P_r)}.}

\item{s_desc}{If \code{TRUE}, sort the classes in descending class weight.}
}
\value{
A list of updated values for \code{z}, \code{b}, \code{Omega}, \code{s},
and \code{C}.
}
\description{
This function updates the latent classes based on a Dirichlet process.
}
\details{
To be added.
}
\examples{
set.seed(1)
z <- c(rep(1,20),rep(2,30))
b <- matrix(c(1,1,1,-1), ncol=2)
Omega <- matrix(c(1,0.3,0.3,0.5,1,-0.3,-0.3,0.8), ncol=2)
beta <- sapply(z, function(z) rmvnorm(b[,z], matrix(Omega[,z],2,2)))
delta <- 1
xi <- numeric(2)
D <- diag(2)
nu <- 4
Theta <- diag(2)
RprobitB:::update_classes_dp(
  Cmax = 10, beta = beta, z = z, b = b, Omega = Omega,
  delta = delta, xi = xi, D = D, nu = nu, Theta = Theta
)
}
\keyword{internal}
