% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_results.R
\name{export_results}
\alias{export_results}
\title{Export experiment results to a data.frame or file.}
\usage{
export_results(experiment, tracks = "all", file = NULL)
}
\arguments{
\item{experiment}{An \code{rtrack_experiment} object from
\code{\link{read_experiment}}.}

\item{tracks}{Which tracks should be exported. Default, 'all', exports the
entire experiment object. A subset of tracks can be specified using either
numeric indices or a vector of track IDs following usual R standards.}

\item{file}{The file to which the results will be written. If \code{NULL}
(the default), the data will be returned as a
\code{\link[base]{data.frame}}.}
}
\value{
A \code{data.frame} containing the experimental groups and factors
  (as supplied in the original experiment description) together with the
  summary metrics and strategy calls). This is returned invisibly if
  \code{file} is specified.
}
\description{
Binds experiment data together with analysis results and optionally writes
this to file.
}
\details{
For convenience, the strategy calls are performed within this function so the
user does not necessarily have to have run them previously. A non-thresholded
set of strategies will be exported. If only a thresholded subset should be
exported, then this can be achieved by performing thresholding separately and
passing the rownames to this function as the parameter \code{tracks}.

If \code{file} is supplied, the file extension will be used to determine
which format to save the file in. The formats ".csv", ".csv2" (see
\code{\link[utils]{write.table}} for details of the formats), ".tsv" (
tab-delimited text; can also  be written as ".txt" or ".tab") and ".xlsx"
(default) are currently supported. If the file extension is not in this list,
the data will be written as tab-delimited text with a warning. Note that the
Excel '.xlsx' format is supported, but the older '.xls' is not.
}
\examples{
require(Rtrack)
experiment.description <- system.file("extdata", "Minimal_experiment.xlsx",
  package = "Rtrack")
experiment <- read_experiment(experiment.description, format = "excel",
  project.dir = system.file("extdata", "", package = "Rtrack"))
# The code below returns a data.frame. 
# Use the parameter 'file' to write to a file instead.
export_results(experiment)

}
